/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.log.EventCategoryTO;
import org.apache.syncope.common.lib.log.LogAppender;
import org.apache.syncope.common.lib.log.LogStatementTO;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.apache.syncope.common.lib.types.LoggerType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.MemoryAppender;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.audit.AuditAppender;
import org.apache.syncope.core.logic.init.LoggerLoader;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.LoggerDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Logger;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.spring.BeanUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

@Component
public class LoggerLogic
extends AbstractTransactionalLogic<LoggerTO> {
    @Autowired
    private LoggerLoader loggerLoader;
    @Autowired
    private LoggerDAO loggerDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private EntityFactory entityFactory;

    private List<LoggerTO> list(LoggerType type) {
        return (List)CollectionUtils.collect((Iterable)this.loggerDAO.findAll(type), (Transformer)new Transformer<Logger, LoggerTO>(){

            public LoggerTO transform(Logger logger) {
                LoggerTO loggerTO = new LoggerTO();
                BeanUtils.copyProperties((Object)logger, (Object)loggerTO);
                return loggerTO;
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('LOG_LIST') and authentication.details.domain == T(org.apache.syncope.common.lib.SyncopeConstants).MASTER_DOMAIN")
    public List<LogAppender> memoryAppenders() {
        return (List)CollectionUtils.collect(this.loggerLoader.getMemoryAppenders().keySet(), (Transformer)new Transformer<String, LogAppender>(){

            public LogAppender transform(String input) {
                LogAppender logAppender = new LogAppender();
                logAppender.setName(input);
                return logAppender;
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('LOG_READ') and authentication.details.domain == T(org.apache.syncope.common.lib.SyncopeConstants).MASTER_DOMAIN")
    public List<LogStatementTO> getLastLogStatements(String memoryAppender) {
        MemoryAppender appender = this.loggerLoader.getMemoryAppenders().get(memoryAppender);
        if (appender == null) {
            throw new NotFoundException("Appender " + memoryAppender);
        }
        return (List)CollectionUtils.collect(appender.getStatements(), (Transformer)TransformerUtils.nopTransformer(), new ArrayList());
    }

    @PreAuthorize(value="hasRole('LOG_LIST') and authentication.details.domain == T(org.apache.syncope.common.lib.SyncopeConstants).MASTER_DOMAIN")
    @Transactional(readOnly=true)
    public List<LoggerTO> listLogs() {
        return this.list(LoggerType.LOG);
    }

    @PreAuthorize(value="hasRole('AUDIT_LIST')")
    @Transactional(readOnly=true)
    public List<AuditLoggerName> listAudits() {
        return (List)CollectionUtils.collect((Iterator)IteratorUtils.filteredIterator(this.list(LoggerType.AUDIT).iterator(), (Predicate)PredicateUtils.notNullPredicate()), (Transformer)new Transformer<LoggerTO, AuditLoggerName>(){

            public AuditLoggerName transform(LoggerTO logger) {
                AuditLoggerName result = null;
                try {
                    result = AuditLoggerName.fromLoggerName((String)logger.getKey());
                }
                catch (Exception e) {
                    AbstractLogic.LOG.warn("Unexpected audit logger name: {}", (Object)logger.getKey(), (Object)e);
                }
                return result;
            }
        }, new ArrayList());
    }

    private void throwInvalidLogger(LoggerType type) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidLogger);
        sce.getElements().add("Expected " + type.name());
        throw sce;
    }

    @PreAuthorize(value="hasRole('LOG_READ') and authentication.details.domain == T(org.apache.syncope.common.lib.SyncopeConstants).MASTER_DOMAIN")
    @Transactional(readOnly=true)
    public LoggerTO readLog(String name) {
        for (LoggerTO logger : this.listLogs()) {
            if (!logger.getKey().equals(name)) continue;
            return logger;
        }
        throw new NotFoundException("Logger " + name);
    }

    @PreAuthorize(value="hasRole('AUDIT_READ')")
    @Transactional(readOnly=true)
    public LoggerTO readAudit(String name) {
        for (AuditLoggerName logger : this.listAudits()) {
            if (!logger.toLoggerName().equals(name)) continue;
            LoggerTO loggerTO = new LoggerTO();
            loggerTO.setKey(logger.toLoggerName());
            loggerTO.setLevel(LoggerLevel.DEBUG);
            return loggerTO;
        }
        throw new NotFoundException("Logger " + name);
    }

    private LoggerTO setLevel(final String name, Level level, LoggerType expectedType) {
        LoggerConfig logConf;
        Logger syncopeLogger = this.loggerDAO.find(name);
        if (syncopeLogger == null) {
            LOG.debug("Logger {} not found: creating new...", (Object)name);
            syncopeLogger = (Logger)this.entityFactory.newEntity(Logger.class);
            syncopeLogger.setKey(name);
            syncopeLogger.setType(name.startsWith(LoggerType.AUDIT.getPrefix()) ? LoggerType.AUDIT : LoggerType.LOG);
        }
        if (expectedType != syncopeLogger.getType()) {
            this.throwInvalidLogger(expectedType);
        }
        syncopeLogger.setLevel(LoggerLevel.fromLevel((Level)level));
        syncopeLogger = this.loggerDAO.save(syncopeLogger);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        if (LoggerType.AUDIT.equals((Object)syncopeLogger.getType())) {
            String auditLoggerName = AuditLoggerName.getAuditEventLoggerName((String)AuthContextUtils.getDomain(), (String)syncopeLogger.getKey());
            logConf = ctx.getConfiguration().getLoggerConfig(auditLoggerName);
            boolean isRootLogConf = "".equals(logConf.getName());
            if (isRootLogConf) {
                logConf = new LoggerConfig(auditLoggerName, null, false);
            }
            for (AuditAppender auditAppender : this.loggerLoader.auditAppenders(AuthContextUtils.getDomain())) {
                if (!IterableUtils.matchesAny(auditAppender.getEvents(), (Predicate)new Predicate<AuditLoggerName>(){

                    public boolean evaluate(AuditLoggerName auditLoggerName) {
                        return name.equalsIgnoreCase(auditLoggerName.toLoggerName());
                    }
                })) continue;
                this.loggerLoader.addAppenderToContext(ctx, auditAppender, logConf);
            }
            if (isRootLogConf) {
                ctx.getConfiguration().addLogger(auditLoggerName, logConf);
            }
        } else {
            logConf = "ROOT".equals(name) ? ctx.getConfiguration().getLoggerConfig("") : ctx.getConfiguration().getLoggerConfig(name);
        }
        logConf.setLevel(level);
        ctx.updateLoggers();
        LoggerTO result = new LoggerTO();
        BeanUtils.copyProperties((Object)syncopeLogger, (Object)result);
        return result;
    }

    @PreAuthorize(value="hasRole('LOG_SET_LEVEL') and authentication.details.domain == T(org.apache.syncope.common.lib.SyncopeConstants).MASTER_DOMAIN")
    public LoggerTO setLogLevel(String name, Level level) {
        return this.setLevel(name, level, LoggerType.LOG);
    }

    @PreAuthorize(value="hasRole('AUDIT_ENABLE')")
    public void enableAudit(AuditLoggerName auditLoggerName) {
        try {
            this.setLevel(auditLoggerName.toLoggerName(), Level.DEBUG, LoggerType.AUDIT);
        }
        catch (IllegalArgumentException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidLogger);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    private LoggerTO delete(String name, LoggerType expectedType) {
        Logger syncopeLogger = this.loggerDAO.find(name);
        if (syncopeLogger == null) {
            throw new NotFoundException("Logger " + name);
        }
        if (expectedType != syncopeLogger.getType()) {
            this.throwInvalidLogger(expectedType);
        }
        LoggerTO loggerToDelete = new LoggerTO();
        BeanUtils.copyProperties((Object)syncopeLogger, (Object)loggerToDelete);
        this.loggerDAO.delete(syncopeLogger);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        String auditLoggerName = AuditLoggerName.getAuditEventLoggerName((String)AuthContextUtils.getDomain(), (String)syncopeLogger.getKey());
        org.apache.logging.log4j.core.Logger logger = "ROOT".equals(name) ? ctx.getLogger("") : (LoggerType.AUDIT.equals((Object)syncopeLogger.getType()) ? ctx.getLogger(auditLoggerName) : ctx.getLogger(name));
        logger.setLevel(Level.OFF);
        ctx.updateLoggers();
        return loggerToDelete;
    }

    @PreAuthorize(value="hasRole('LOG_DELETE') and authentication.details.domain == T(org.apache.syncope.common.lib.SyncopeConstants).MASTER_DOMAIN")
    public LoggerTO deleteLog(String name) {
        return this.delete(name, LoggerType.LOG);
    }

    @PreAuthorize(value="hasRole('AUDIT_DISABLE')")
    public void disableAudit(AuditLoggerName auditLoggerName) {
        try {
            this.delete(auditLoggerName.toLoggerName(), LoggerType.AUDIT);
        }
        catch (NotFoundException e) {
            LOG.debug("Ignoring disable of non existing logger {}", (Object)auditLoggerName.toLoggerName());
        }
        catch (IllegalArgumentException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidLogger);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    @PreAuthorize(value="hasRole('AUDIT_LIST') or hasRole('NOTIFICATION_LIST')")
    public List<EventCategoryTO> listAuditEvents() {
        HashSet<EventCategoryTO> events = new HashSet<EventCategoryTO>();
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)this.getClass().getPackage().getName())) + "/**/*.class";
            for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
                MetadataReader metadataReader;
                Class<?> clazz;
                if (!resource.isReadable() || !(clazz = Class.forName((metadataReader = metadataReaderFactory.getMetadataReader(resource)).getClassMetadata().getClassName())).isAnnotationPresent(Component.class) || !AbstractLogic.class.isAssignableFrom(clazz)) continue;
                EventCategoryTO eventCategoryTO = new EventCategoryTO();
                eventCategoryTO.setCategory(clazz.getSimpleName());
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!Modifier.isPublic(method.getModifiers()) || eventCategoryTO.getEvents().contains(method.getName())) continue;
                    eventCategoryTO.getEvents().add(method.getName());
                }
                events.add(eventCategoryTO);
            }
            EventCategoryTO authenticationControllerEvents = new EventCategoryTO();
            authenticationControllerEvents.setCategory("Authentication");
            authenticationControllerEvents.getEvents().add("login");
            events.add(authenticationControllerEvents);
            events.add(new EventCategoryTO(AuditElements.EventCategoryType.PROPAGATION));
            events.add(new EventCategoryTO(AuditElements.EventCategoryType.PULL));
            events.add(new EventCategoryTO(AuditElements.EventCategoryType.PUSH));
            for (AnyTypeKind anyTypeKind : AnyTypeKind.values()) {
                for (ExternalResource resource : this.resourceDAO.findAll()) {
                    String event;
                    EventCategoryTO propEventCategoryTO = new EventCategoryTO(AuditElements.EventCategoryType.PROPAGATION);
                    EventCategoryTO pullEventCategoryTO = new EventCategoryTO(AuditElements.EventCategoryType.PULL);
                    EventCategoryTO pushEventCategoryTO = new EventCategoryTO(AuditElements.EventCategoryType.PUSH);
                    propEventCategoryTO.setCategory(anyTypeKind.name().toLowerCase());
                    propEventCategoryTO.setSubcategory(resource.getKey());
                    pullEventCategoryTO.setCategory(anyTypeKind.name().toLowerCase());
                    pushEventCategoryTO.setCategory(anyTypeKind.name().toLowerCase());
                    pullEventCategoryTO.setSubcategory(resource.getKey());
                    pushEventCategoryTO.setSubcategory(resource.getKey());
                    for (ResourceOperation resourceOperation : ResourceOperation.values()) {
                        propEventCategoryTO.getEvents().add(resourceOperation.name().toLowerCase());
                    }
                    pullEventCategoryTO.getEvents().add(ResourceOperation.DELETE.name().toLowerCase());
                    for (ResourceOperation resourceOperation : UnmatchingRule.values()) {
                        event = UnmatchingRule.toEventName((UnmatchingRule)resourceOperation);
                        pullEventCategoryTO.getEvents().add(event);
                        pushEventCategoryTO.getEvents().add(event);
                    }
                    for (ResourceOperation resourceOperation : MatchingRule.values()) {
                        event = MatchingRule.toEventName((MatchingRule)resourceOperation);
                        pullEventCategoryTO.getEvents().add(event);
                        pushEventCategoryTO.getEvents().add(event);
                    }
                    events.add(propEventCategoryTO);
                    events.add(pullEventCategoryTO);
                    events.add(pushEventCategoryTO);
                }
            }
            for (SchedTask task : this.taskDAO.findAll(TaskType.SCHEDULED)) {
                EventCategoryTO eventCategoryTO = new EventCategoryTO(AuditElements.EventCategoryType.TASK);
                eventCategoryTO.setCategory(Class.forName(task.getJobDelegateClassName()).getSimpleName());
                events.add(eventCategoryTO);
            }
            EventCategoryTO eventCategoryTO = new EventCategoryTO(AuditElements.EventCategoryType.TASK);
            eventCategoryTO.setCategory(PullJobDelegate.class.getSimpleName());
            events.add(eventCategoryTO);
            eventCategoryTO = new EventCategoryTO(AuditElements.EventCategoryType.TASK);
            eventCategoryTO.setCategory(PushJobDelegate.class.getSimpleName());
            events.add(eventCategoryTO);
        }
        catch (Exception e) {
            LOG.error("Failure retrieving audit/notification events", (Throwable)e);
        }
        return new ArrayList<EventCategoryTO>(events);
    }

    @Override
    protected LoggerTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

