/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.DomainTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.DomainsHolder;
import org.apache.syncope.core.persistence.api.dao.DomainDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.Domain;
import org.apache.syncope.core.provisioning.api.data.DomainDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class DomainLogic
extends AbstractTransactionalLogic<DomainTO> {
    @Autowired
    private DomainsHolder domainsHolder;
    @Autowired
    private DomainDataBinder binder;
    @Autowired
    private DomainDAO domainDAO;

    @PreAuthorize(value="hasRole('DOMAIN_READ') and authentication.details.domain == T(org.apache.syncope.common.lib.SyncopeConstants).MASTER_DOMAIN")
    public DomainTO read(String key) {
        Domain domain = this.domainDAO.find(key);
        if (domain == null) {
            LOG.error("Could not find domain '" + key + "'");
            throw new NotFoundException(key);
        }
        return this.binder.getDomainTO(domain);
    }

    @PreAuthorize(value="isAuthenticated()")
    public List<DomainTO> list() {
        return (List)CollectionUtils.collect((Iterable)this.domainDAO.findAll(), (Transformer)new Transformer<Domain, DomainTO>(){

            public DomainTO transform(Domain input) {
                return DomainLogic.this.binder.getDomainTO(input);
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('DOMAIN_CREATE') and authentication.details.domain == T(org.apache.syncope.common.lib.SyncopeConstants).MASTER_DOMAIN")
    public DomainTO create(DomainTO domainTO) {
        if (!this.domainsHolder.getDomains().keySet().contains(domainTO.getKey())) {
            throw new NotFoundException("No configuration is available for domain " + domainTO.getKey());
        }
        return this.binder.getDomainTO(this.domainDAO.save(this.binder.create(domainTO)));
    }

    @PreAuthorize(value="hasRole('DOMAIN_UPDATE') and authentication.details.domain == T(org.apache.syncope.common.lib.SyncopeConstants).MASTER_DOMAIN")
    public DomainTO update(DomainTO domainTO) {
        Domain domain = this.domainDAO.find(domainTO.getKey());
        if (domain == null) {
            LOG.error("Could not find domain '" + domainTO.getKey() + "'");
            throw new NotFoundException(domainTO.getKey());
        }
        this.binder.update(domain, domainTO);
        domain = this.domainDAO.save(domain);
        return this.binder.getDomainTO(domain);
    }

    @PreAuthorize(value="hasRole('DOMAIN_DELETE') and authentication.details.domain == T(org.apache.syncope.common.lib.SyncopeConstants).MASTER_DOMAIN")
    public DomainTO delete(String key) {
        Domain domain = this.domainDAO.find(key);
        if (domain == null) {
            LOG.error("Could not find domain '" + key + "'");
            throw new NotFoundException(key);
        }
        DomainTO deleted = this.binder.getDomainTO(domain);
        this.domainDAO.delete(key);
        return deleted;
    }

    @Override
    protected DomainTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof DomainTO)) continue;
                key = ((DomainTO)args[i]).getKey();
            }
        }
        if (StringUtils.isNotBlank(key)) {
            try {
                return this.binder.getDomainTO(this.domainDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

