/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.provisioning.api.data.AnyTypeClassDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AnyTypeClassLogic
extends AbstractTransactionalLogic<AnyTypeClassTO> {
    @Autowired
    private AnyTypeClassDataBinder binder;
    @Autowired
    private AnyTypeClassDAO anyTypeClassDAO;

    @PreAuthorize(value="hasRole('ANYTYPECLASS_READ')")
    @Transactional(readOnly=true)
    public AnyTypeClassTO read(String key) {
        AnyTypeClass anyType = this.anyTypeClassDAO.find(key);
        if (anyType == null) {
            LOG.error("Could not find anyType '" + key + "'");
            throw new NotFoundException(key);
        }
        return this.binder.getAnyTypeClassTO(anyType);
    }

    @PreAuthorize(value="hasRole('ANYTYPECLASS_LIST')")
    @Transactional(readOnly=true)
    public List<AnyTypeClassTO> list() {
        return (List)CollectionUtils.collect((Iterable)this.anyTypeClassDAO.findAll(), (Transformer)new Transformer<AnyTypeClass, AnyTypeClassTO>(){

            public AnyTypeClassTO transform(AnyTypeClass input) {
                return AnyTypeClassLogic.this.binder.getAnyTypeClassTO(input);
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('ANYTYPECLASS_CREATE')")
    public AnyTypeClassTO create(AnyTypeClassTO anyTypeClassTO) {
        if (StringUtils.isBlank((CharSequence)anyTypeClassTO.getKey())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add(AnyTypeClass.class.getSimpleName() + " name");
            throw sce;
        }
        if (this.anyTypeClassDAO.find(anyTypeClassTO.getKey()) != null) {
            throw new DuplicateException(anyTypeClassTO.getKey());
        }
        return this.binder.getAnyTypeClassTO(this.anyTypeClassDAO.save(this.binder.create(anyTypeClassTO)));
    }

    @PreAuthorize(value="hasRole('ANYTYPECLASS_UPDATE')")
    public AnyTypeClassTO update(AnyTypeClassTO anyTypeClassTO) {
        AnyTypeClass anyType = this.anyTypeClassDAO.find(anyTypeClassTO.getKey());
        if (anyType == null) {
            LOG.error("Could not find anyTypeClass '" + anyTypeClassTO.getKey() + "'");
            throw new NotFoundException(anyTypeClassTO.getKey());
        }
        this.binder.update(anyType, anyTypeClassTO);
        anyType = this.anyTypeClassDAO.save(anyType);
        return this.binder.getAnyTypeClassTO(anyType);
    }

    @PreAuthorize(value="hasRole('ANYTYPECLASS_DELETE')")
    public AnyTypeClassTO delete(String key) {
        AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(key);
        if (anyTypeClass == null) {
            LOG.error("Could not find anyTypeClass '" + key + "'");
            throw new NotFoundException(key);
        }
        AnyTypeClassTO deleted = this.binder.getAnyTypeClassTO(anyTypeClass);
        this.anyTypeClassDAO.delete(key);
        return deleted;
    }

    @Override
    protected AnyTypeClassTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof AnyTypeClassTO)) continue;
                key = ((AnyTypeClassTO)args[i]).getKey();
            }
        }
        if (StringUtils.isNotBlank(key)) {
            try {
                return this.binder.getAnyTypeClassTO(this.anyTypeClassDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

