/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ResponseHeader;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.patch.ResourceDeassociationPatch;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.PagedConnObjectTOResult;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.rest.api.beans.ConnObjectTOListQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Api(tags={"Resources"}, authorizations={@Authorization(value="BasicAuthentication"), @Authorization(value="Bearer")})
@Path(value="resources")
public interface ResourceService
extends JAXRSService {
    @GET
    @Path(value="{key}/{anyTypeKey}/{anyKey}")
    @Produces(value={"application/json", "application/xml"})
    public ConnObjectTO readConnObject(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2, @NotNull @PathParam(value="anyKey") String var3);

    @GET
    @Path(value="{key}/{anyTypeKey}")
    @Produces(value={"application/json", "application/xml"})
    public PagedConnObjectTOResult listConnObjects(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2, @BeanParam ConnObjectTOListQuery var3);

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/xml"})
    public ResourceTO read(@NotNull @PathParam(value="key") String var1);

    @GET
    @Produces(value={"application/json", "application/xml"})
    public List<ResourceTO> list();

    @ApiResponses(value={@ApiResponse(code=201, message="Resource successfully created", responseHeaders={@ResponseHeader(name="X-Syncope-Key", response=String.class, description="Key value for the entity created"), @ResponseHeader(name="Location", response=String.class, description="URL of the entity created")})})
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response create(@NotNull ResourceTO var1);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public void update(@NotNull ResourceTO var1);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @POST
    @Path(value="{key}/{anyTypeKey}")
    @Produces(value={"application/json", "application/xml"})
    public void setLatestSyncToken(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @DELETE
    @Path(value="{key}/{anyTypeKey}")
    @Produces(value={"application/json", "application/xml"})
    public void removeSyncToken(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public void delete(@NotNull @PathParam(value="key") String var1);

    @ApiResponses(value={@ApiResponse(code=204, message="Operation was successful")})
    @POST
    @Path(value="check")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public void check(@NotNull ResourceTO var1);

    @POST
    @Path(value="{key}/bulkDeassociation/{anyTypeKey}/{action}")
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    public BulkActionResult bulkDeassociation(@NotNull ResourceDeassociationPatch var1);
}

