/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.tooltip;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.widget.tooltip.TooltipBehavior;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.util.string.ComponentRenderer;
import org.apache.wicket.markup.html.WebMarkupContainer;

public abstract class CustomTooltipBehavior
extends TooltipBehavior {
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_ID = "tooltip";

    public CustomTooltipBehavior() {
    }

    public CustomTooltipBehavior(Options options) {
        super(options);
    }

    public void bind(Component component) {
        super.bind(component);
        component.add(new Behavior[]{AttributeModifier.replace((String)"data-tooltip", (Serializable)Boolean.valueOf(true))});
        this.selector = IJQueryWidget.JQueryWidget.getSelector((Component)component);
        this.setOption("items", Options.asString((String)"[data-tooltip]"));
        this.setOption("content", String.format("function() { return %s; }", this.render(this.newContent(CONTENT_ID))));
    }

    protected abstract WebMarkupContainer newContent(String var1);

    private String render(WebMarkupContainer container) {
        return this.quote(String.valueOf(ComponentRenderer.renderComponent((Component)container)));
    }

    protected String quote(String content) {
        return JSONObject.quote((String)content);
    }

    @Override
    protected String $() {
        if (this.selector == null) {
            return CustomTooltipBehavior.$(this.method, this.options.toString());
        }
        return super.$();
    }

    private static String $(String method, String options) {
        return String.format("jQuery(document).%s(%s);", method, options);
    }
}

