/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.progressbar;

import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.JQueryGenericContainer;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.event.IValueChangedListener;
import com.googlecode.wicket.jquery.ui.ajax.OnChangeAjaxBehavior;
import com.googlecode.wicket.jquery.ui.widget.progressbar.ProgressBarBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public class ProgressBar
extends JQueryGenericContainer<Integer>
implements IJQueryAjaxAware,
IValueChangedListener {
    private static final long serialVersionUID = 1L;
    private static final int MIN = 0;
    private static final int MAX = 100;

    public ProgressBar(String id) {
        super(id);
    }

    public ProgressBar(String id, IModel<Integer> model) {
        super(id, model);
    }

    public void setModelObject(Integer value) {
        Integer v = (Integer)Args.notNull((Object)value, (String)"value");
        if (v < 0) {
            v = 0;
        } else if (v > 100) {
            v = 100;
        }
        super.setModelObject((Object)v);
    }

    public void forward(IPartialPageRequestHandler handler) {
        this.forward(handler, 1);
    }

    public final void forward(IPartialPageRequestHandler handler, int step) {
        this.setModelObject((Integer)this.getModelObject() + step);
        this.refresh(handler);
    }

    public final void backward(IPartialPageRequestHandler handler) {
        this.backward(handler, 1);
    }

    public final void backward(IPartialPageRequestHandler handler, int step) {
        this.setModelObject((Integer)this.getModelObject() - step);
        this.refresh(handler);
    }

    public final void refresh(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)this.widgetBehavior.toString());
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof OnChangeAjaxBehavior.ChangeEvent) {
            this.onValueChanged((IPartialPageRequestHandler)target);
            if ((Integer)this.getModelObject() == 100) {
                this.onComplete(target);
            }
        }
    }

    public void onValueChanged(IPartialPageRequestHandler handler) {
    }

    protected void onComplete(AjaxRequestTarget target) {
    }

    protected void onModelChanged() {
        this.widgetBehavior.setOption("value", this.getModelObject());
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new ProgressBarBehavior(selector){
            private static final long serialVersionUID = 1L;

            public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
                ProgressBar.this.onAjax(target, event);
            }
        };
    }
}

