/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.interaction.selectable;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.interaction.selectable.ISelectableListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.StringValue;

public abstract class SelectableBehavior<T extends Serializable>
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "selectable";
    private ISelectableListener<T> listener;
    private JQueryAjaxBehavior onStopAjaxBehavior;

    public SelectableBehavior(String selector, ISelectableListener<T> listener) {
        this(selector, new Options(), listener);
    }

    public SelectableBehavior(String selector, Options options, ISelectableListener<T> listener) {
        super(selector, METHOD, options);
        this.listener = (ISelectableListener)Args.notNull(listener, (String)"listener");
    }

    protected abstract List<T> getItemList();

    protected abstract String getItemSelector();

    public void bind(Component component) {
        super.bind(component);
        this.onStopAjaxBehavior = this.newOnStopAjaxBehavior(this);
        component.add(new Behavior[]{this.onStopAjaxBehavior});
    }

    @Override
    public void onConfigure(Component component) {
        this.setOption("stop", this.onStopAjaxBehavior.getCallbackFunction());
        this.setOption("filter", Options.asString((String)this.getItemSelector()));
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof StopEvent) {
            ArrayList items = Generics.newArrayList();
            List<T> list = this.getItemList();
            for (int index : ((StopEvent)event).getIndexes()) {
                if (index >= list.size()) continue;
                items.add(list.get(index));
            }
            this.listener.onSelect(target, items);
        }
    }

    protected JQueryAjaxBehavior newOnStopAjaxBehavior(IJQueryAjaxAware source) {
        return new OnStopAjaxBehavior(source);
    }

    protected static class StopEvent
    extends JQueryEvent {
        private final List<Integer> indexes = Generics.newArrayList();

        public StopEvent() {
            StringValue values = RequestCycleUtils.getQueryParameterValue((String)"indexes");
            if (values != null) {
                Pattern pattern = Pattern.compile("(\\d+)");
                Matcher matcher = pattern.matcher(values.toString());
                while (matcher.find()) {
                    this.indexes.add(Integer.valueOf(matcher.group()));
                }
            }
        }

        public List<Integer> getIndexes() {
            return this.indexes;
        }
    }

    protected class OnStopAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnStopAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.resolved((String)"indexes", (String)"indexes")};
        }

        public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
            String selector = String.format("%s %s", SelectableBehavior.this.selector, SelectableBehavior.this.getItemSelector());
            String indexes = "var indexes=[]; jQuery('.ui-selected', this).each(function() { indexes.push(jQuery('" + selector + "').index(this)); }); ";
            return indexes + super.getCallbackFunctionBody(parameters);
        }

        protected JQueryEvent newEvent() {
            return new StopEvent();
        }
    }
}

