/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.SAML2IdPDAO;
import org.apache.syncope.core.persistence.api.entity.SAML2IdP;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPASAML2IdP;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPASAML2IdPDAO
extends AbstractDAO<SAML2IdP>
implements SAML2IdPDAO {
    @Transactional(readOnly=true)
    public SAML2IdP find(String key) {
        return (SAML2IdP)this.entityManager().find(JPASAML2IdP.class, (Object)key);
    }

    @Transactional(readOnly=true)
    public SAML2IdP findByEntityID(String entityID) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPASAML2IdP.class.getSimpleName() + " e WHERE e.entityID = :entityID", SAML2IdP.class);
        query.setParameter("entityID", (Object)entityID);
        SAML2IdP result = null;
        try {
            result = (SAML2IdP)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No IdP found with entityID {}", (Object)entityID, (Object)e);
        }
        return result;
    }

    @Transactional(readOnly=true)
    public List<SAML2IdP> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPASAML2IdP.class.getSimpleName() + " e", SAML2IdP.class);
        return query.getResultList();
    }

    public SAML2IdP save(SAML2IdP idp) {
        return (SAML2IdP)this.entityManager().merge((Object)idp);
    }

    public void delete(String key) {
        SAML2IdP idp = this.find(key);
        if (idp != null) {
            this.entityManager().remove((Object)idp);
        }
    }
}

