/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.activiti.task;

import java.util.Set;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.workflow.activiti.task.AbstractActivitiServiceTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Update
extends AbstractActivitiServiceTask {
    @Autowired
    private UserDataBinder dataBinder;
    @Autowired
    private UserDAO userDAO;

    @Override
    protected void doExecute(String executionId) {
        User user = (User)this.engine.getRuntimeService().getVariable(executionId, "user", User.class);
        UserPatch userPatch = (UserPatch)this.engine.getRuntimeService().getVariable(executionId, "userPatch", UserPatch.class);
        user = (User)this.userDAO.save((Any)user);
        UserTO original = this.dataBinder.getUserTO(user, true);
        PropagationByResource propByRes = this.dataBinder.update(user, userPatch);
        PasswordPatch password = userPatch.getPassword();
        Set virAttrs = userPatch.getVirAttrs();
        UserTO updated = this.dataBinder.getUserTO(user.getKey());
        userPatch = AnyOperations.diff((UserTO)updated, (UserTO)original, (boolean)false);
        userPatch.setPassword(password);
        userPatch.getVirAttrs().clear();
        userPatch.getVirAttrs().addAll(virAttrs);
        this.engine.getRuntimeService().setVariable(executionId, "user", (Object)user);
        this.engine.getRuntimeService().setVariable(executionId, "userTO", (Object)updated);
        this.engine.getRuntimeService().setVariable(executionId, "userPatch", (Object)userPatch);
        this.engine.getRuntimeService().setVariable(executionId, "propByResource", (Object)propByRes);
    }
}

