/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.activiti.spring;

import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.activiti.engine.DynamicBpmnService;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.ProcessEngineImpl;
import org.apache.syncope.core.spring.security.AuthContextUtils;

public class DomainProcessEngine
implements ProcessEngine {
    private final Map<String, ProcessEngine> engines;

    public DomainProcessEngine(Map<String, ProcessEngine> engines) {
        this.engines = Collections.synchronizedMap(engines);
    }

    public Map<String, ProcessEngine> getEngines() {
        return this.engines;
    }

    public String getName() {
        return this.engines.get(AuthContextUtils.getDomain()).getName();
    }

    public void close() {
        for (ProcessEngine engine : this.engines.values()) {
            engine.close();
        }
    }

    public RepositoryService getRepositoryService() {
        return this.engines.get(AuthContextUtils.getDomain()).getRepositoryService();
    }

    public RuntimeService getRuntimeService() {
        return this.engines.get(AuthContextUtils.getDomain()).getRuntimeService();
    }

    public FormService getFormService() {
        return this.engines.get(AuthContextUtils.getDomain()).getFormService();
    }

    public TaskService getTaskService() {
        return this.engines.get(AuthContextUtils.getDomain()).getTaskService();
    }

    public HistoryService getHistoryService() {
        return this.engines.get(AuthContextUtils.getDomain()).getHistoryService();
    }

    public IdentityService getIdentityService() {
        return this.engines.get(AuthContextUtils.getDomain()).getIdentityService();
    }

    public ManagementService getManagementService() {
        return this.engines.get(AuthContextUtils.getDomain()).getManagementService();
    }

    public ProcessEngineConfiguration getProcessEngineConfiguration() {
        return this.engines.get(AuthContextUtils.getDomain()).getProcessEngineConfiguration();
    }

    public DynamicBpmnService getDynamicBpmnService() {
        return this.engines.get(AuthContextUtils.getDomain()).getDynamicBpmnService();
    }

    public DataSource getDataSource() {
        ProcessEngineImpl engine = (ProcessEngineImpl)this.engines.get(AuthContextUtils.getDomain());
        return engine.getProcessEngineConfiguration().getDataSource();
    }
}

