/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.activiti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;

public class SyncopeGroupQueryImpl
implements GroupQuery {
    private final GroupDAO groupDAO;
    private String groupId;
    private List<Group> result;

    public SyncopeGroupQueryImpl(GroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public GroupQuery groupId(String groupId) {
        try {
            this.groupId = groupId;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this;
    }

    public GroupQuery groupName(String groupName) {
        return this;
    }

    public GroupQuery groupNameLike(String groupNameLike) {
        return this;
    }

    public GroupQuery groupType(String groupType) {
        return this;
    }

    public GroupQuery groupMember(String groupMemberUserId) {
        return this;
    }

    public GroupQuery orderByGroupId() {
        return this;
    }

    public GroupQuery orderByGroupName() {
        return this;
    }

    public GroupQuery orderByGroupType() {
        return this;
    }

    public GroupQuery asc() {
        return this;
    }

    public GroupQuery desc() {
        return this;
    }

    private Group fromSyncopeGroup(org.apache.syncope.core.persistence.api.entity.group.Group group) {
        return new GroupEntity(group.getKey());
    }

    private void execute() {
        if (this.groupId != null) {
            org.apache.syncope.core.persistence.api.entity.group.Group syncopeGroup = this.groupDAO.findByName(this.groupId);
            this.result = syncopeGroup == null ? Collections.emptyList() : Collections.singletonList(this.fromSyncopeGroup(syncopeGroup));
        }
        if (this.result == null) {
            this.result = new ArrayList<Group>();
            for (int page = 1; page <= this.groupDAO.count() / 500 + 1; ++page) {
                CollectionUtils.collect((Iterable)this.groupDAO.findAll(page, 500), (Transformer)new Transformer<org.apache.syncope.core.persistence.api.entity.group.Group, Group>(){

                    public Group transform(org.apache.syncope.core.persistence.api.entity.group.Group group) {
                        return SyncopeGroupQueryImpl.this.fromSyncopeGroup(group);
                    }
                }, this.result);
            }
        }
    }

    public long count() {
        if (this.result == null) {
            this.execute();
        }
        return this.result.size();
    }

    public Group singleResult() {
        if (this.result == null) {
            this.execute();
        }
        if (this.result.isEmpty()) {
            throw new ActivitiException("Empty result");
        }
        return this.result.get(0);
    }

    public List<Group> list() {
        if (this.result == null) {
            this.execute();
        }
        return this.result;
    }

    public List<Group> listPage(int firstResult, int maxResults) {
        return this.list();
    }

    public GroupQuery potentialStarter(String procDefId) {
        throw new UnsupportedOperationException();
    }
}

