/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.activiti;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.syncope.core.workflow.api.WorkflowException;

public final class ActivitiDeployUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Deployment deployDefinition(ProcessEngine engine, String resourceName, byte[] definition) {
        try {
            return engine.getRepositoryService().createDeployment().addInputStream(resourceName, (InputStream)new ByteArrayInputStream(definition)).deploy();
        }
        catch (ActivitiException e) {
            throw new WorkflowException("While importing " + resourceName, (Throwable)e);
        }
    }

    public static void deployModel(ProcessEngine engine, ProcessDefinition procDef) {
        XMLStreamReader xtr = null;
        try (InputStream bpmnStream = engine.getRepositoryService().getResourceAsStream(procDef.getDeploymentId(), procDef.getResourceName());
             InputStreamReader isr = new InputStreamReader(bpmnStream);){
            xtr = XMLInputFactory.newInstance().createXMLStreamReader(isr);
            BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
            Model model = engine.getRepositoryService().newModel();
            ObjectNode modelObjectNode = OBJECT_MAPPER.createObjectNode();
            modelObjectNode.put("name", procDef.getName());
            model.setMetaInfo(modelObjectNode.toString());
            model.setName(procDef.getName());
            model.setDeploymentId(procDef.getDeploymentId());
            model.setVersion(Integer.valueOf(procDef.getVersion()));
            engine.getRepositoryService().saveModel(model);
            engine.getRepositoryService().addModelEditorSource(model.getId(), new BpmnJsonConverter().convertToJson(bpmnModel).toString().getBytes());
        }
        catch (Exception e) {
            throw new WorkflowException("While importing " + procDef.getResourceName(), (Throwable)e);
        }
        finally {
            if (xtr != null) {
                try {
                    xtr.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    private ActivitiDeployUtils() {
    }
}

