/*
 * Decompiled with CFR 0.152.
 */
package com.pingunaut.wicket.chartjs.core;

import com.pingunaut.wicket.chartjs.chart.IChart;
import com.pingunaut.wicket.chartjs.core.ChartBehavior;
import com.pingunaut.wicket.chartjs.options.AbstractChartOptions;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class AbstractChartPanel<C extends IChart<O>, O extends AbstractChartOptions>
extends Panel {
    private static final long serialVersionUID = -5882448897795445250L;
    private final WebMarkupContainer wmc;
    private int width;
    private int height;
    private final IModel<? extends C> chart;

    public AbstractChartPanel(String id, IModel<? extends C> c) {
        super(id, c);
        this.chart = c;
        this.wmc = new WebMarkupContainer("chart");
    }

    public AbstractChartPanel(String id, IModel<? extends C> c, final int width, final int height) {
        super(id);
        this.chart = c;
        this.width = width;
        this.height = height;
        this.wmc = new WebMarkupContainer("chart"){
            private static final long serialVersionUID = 3385419188467369696L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.append("width", (CharSequence)String.valueOf(width), " ");
                tag.append("height", (CharSequence)String.valueOf(height), " ");
            }
        };
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public C getChart() {
        return (C)((IChart)this.chart.getObject());
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.wmc});
        this.wmc.setOutputMarkupId(true);
        this.wmc.add(new Behavior[]{new ChartBehavior()});
    }

    public WebMarkupContainer getChartCanvas() {
        return this.wmc;
    }

    public abstract String generateChart();
}

