/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.AnyObjectPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractProvisioningJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultAnyObjectPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultGroupPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultRealmPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultUserPushResultHandler;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class PushJobDelegate
extends AbstractProvisioningJobDelegate<PushTask> {
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected AnySearchDAO searchDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected RealmDAO realmDAO;
    protected ProvisioningProfile<PushTask, PushActions> profile;
    protected final Map<String, MutablePair<Integer, String>> handled = new HashMap<String, MutablePair<Integer, String>>();
    protected RealmPushResultHandler rhandler;
    protected AnyObjectPushResultHandler ahandler;
    protected UserPushResultHandler uhandler;
    protected GroupPushResultHandler ghandler;

    protected void reportHandled(String anyType, String key) {
        MutablePair pair = this.handled.get(anyType);
        if (pair == null) {
            pair = MutablePair.of((Object)0, null);
            this.handled.put(anyType, (MutablePair<Integer, String>)pair);
        }
        pair.setLeft((Object)((Integer)pair.getLeft() + 1));
        pair.setRight((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String currentStatus() {
        AtomicReference atomicReference = this.status;
        synchronized (atomicReference) {
            if (!this.handled.isEmpty()) {
                StringBuilder builder = new StringBuilder("Processed:\n");
                for (Map.Entry<String, MutablePair<Integer, String>> entry : this.handled.entrySet()) {
                    builder.append(' ').append(entry.getValue().getLeft()).append('\t').append(entry.getKey()).append(" / latest: ").append((String)entry.getValue().getRight()).append('\n');
                }
                this.status.set(builder.toString());
            }
        }
        return (String)this.status.get();
    }

    protected AnyDAO<?> getAnyDAO(AnyTypeKind anyTypeKind) {
        UserDAO result;
        switch (anyTypeKind) {
            case USER: {
                result = this.userDAO;
                break;
            }
            case GROUP: {
                result = this.groupDAO;
                break;
            }
            default: {
                result = this.anyObjectDAO;
            }
        }
        return result;
    }

    protected void doHandle(List<? extends Any<?>> anys, SyncopePushResultHandler handler, ExternalResource resource) throws JobExecutionException {
        for (int i = 0; i < anys.size() && !this.interrupt; ++i) {
            try {
                handler.handle(anys.get(i).getKey());
                this.reportHandled(anys.get(i).getType().getKey(), anys.get(i) instanceof User ? ((User)anys.get(i)).getUsername() : (anys.get(i) instanceof Group ? ((Group)anys.get(i)).getName() : ((AnyObject)anys.get(i)).getName()));
                continue;
            }
            catch (Exception e) {
                LOG.warn("Failure pushing '{}' on '{}'", new Object[]{anys.get(i), resource, e});
                throw new JobExecutionException("While pushing " + anys.get(i) + " on " + resource, (Throwable)e);
            }
        }
    }

    protected RealmPushResultHandler buildRealmHandler() {
        RealmPushResultHandler handler = (RealmPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultRealmPushResultHandler.class, 1, false);
        handler.setProfile(this.profile);
        return handler;
    }

    protected AnyObjectPushResultHandler buildAnyObjectHandler() {
        AnyObjectPushResultHandler handler = (AnyObjectPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultAnyObjectPushResultHandler.class, 1, false);
        handler.setProfile(this.profile);
        return handler;
    }

    protected UserPushResultHandler buildUserHandler() {
        UserPushResultHandler handler = (UserPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultUserPushResultHandler.class, 1, false);
        handler.setProfile(this.profile);
        return handler;
    }

    protected GroupPushResultHandler buildGroupHandler() {
        GroupPushResultHandler handler = (GroupPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultGroupPushResultHandler.class, 1, false);
        handler.setProfile(this.profile);
        return handler;
    }

    @Override
    protected String doExecuteProvisioning(PushTask pushTask, Connector connector, boolean dryRun) throws JobExecutionException {
        LOG.debug("Executing push on {}", (Object)pushTask.getResource());
        ArrayList<PushActions> actions = new ArrayList<PushActions>();
        for (String className : pushTask.getActionsClassNames()) {
            try {
                Class<?> actionsClass = Class.forName(className);
                PushActions pushActions = (PushActions)ApplicationContextProvider.getBeanFactory().createBean(actionsClass, 2, true);
                actions.add(pushActions);
            }
            catch (Exception e) {
                LOG.info("Class '{}' not found", (Object)className, (Object)e);
            }
        }
        this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pushTask);
        this.profile.getActions().addAll(actions);
        this.profile.setDryRun(dryRun);
        this.profile.setResAct(null);
        if (!this.profile.isDryRun()) {
            for (PushActions action : actions) {
                action.beforeAll(this.profile);
            }
        }
        this.status.set("Initialization completed");
        if (pushTask.getResource().getOrgUnit() != null) {
            this.status.set("Pushing realms");
            this.rhandler = this.buildRealmHandler();
            for (Realm realm : this.realmDAO.findDescendants(((PushTask)this.profile.getTask()).getSourceRealm())) {
                if (realm.getParent() == null) continue;
                try {
                    this.rhandler.handle(realm.getKey());
                    this.reportHandled("REALM", realm.getName());
                }
                catch (Exception e) {
                    LOG.warn("Failure pushing '{}' on '{}'", new Object[]{realm, pushTask.getResource(), e});
                    throw new JobExecutionException("While pushing " + realm + " on " + pushTask.getResource(), (Throwable)e);
                }
            }
        }
        this.ahandler = this.buildAnyObjectHandler();
        this.uhandler = this.buildUserHandler();
        this.ghandler = this.buildGroupHandler();
        for (Provision provision : pushTask.getResource().getProvisions()) {
            UserPushResultHandler handler;
            if (provision.getMapping() == null) continue;
            this.status.set("Pushing " + provision.getAnyType().getKey());
            AnyDAO<?> anyDAO = this.getAnyDAO(provision.getAnyType().getKind());
            switch (provision.getAnyType().getKind()) {
                case USER: {
                    handler = this.uhandler;
                    break;
                }
                case GROUP: {
                    handler = this.ghandler;
                    break;
                }
                default: {
                    handler = this.ahandler;
                }
            }
            String filter = pushTask.getFilter(provision.getAnyType()) == null ? null : pushTask.getFilter(provision.getAnyType()).getFIQLCond();
            SearchCond cond = StringUtils.isBlank(filter) ? anyDAO.getAllMatchingCond() : SearchCondConverter.convert((String)filter, (String[])new String[0]);
            int count = this.searchDAO.count(Collections.singleton(((PushTask)this.profile.getTask()).getSourceRealm().getFullPath()), cond, provision.getAnyType().getKind());
            for (int page = 1; page <= count / 500 + 1 && !this.interrupt; ++page) {
                List anys = this.searchDAO.search(Collections.singleton(((PushTask)this.profile.getTask()).getSourceRealm().getFullPath()), cond, page, 500, Collections.emptyList(), provision.getAnyType().getKind());
                this.doHandle(anys, (SyncopePushResultHandler)handler, pushTask.getResource());
            }
        }
        if (!this.profile.isDryRun() && !this.interrupt) {
            for (PushActions action : actions) {
                action.afterAll(this.profile);
            }
        }
        if (this.interrupt) {
            this.interrupted = true;
        }
        this.status.set("Push done");
        String result = this.createReport(this.profile.getResults(), pushTask.getResource(), dryRun);
        LOG.debug("Push result: {}", (Object)result);
        return result;
    }
}

