/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.policy.PullPolicySpec;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.attrvalue.validation.ParsingValidationException;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnitItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.pushpull.PullCorrelationRule;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.api.utils.EntityUtils;
import org.apache.syncope.core.provisioning.java.IntAttrNameParser;
import org.apache.syncope.core.provisioning.java.pushpull.PlainAttrsPullCorrelationRule;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Component
public class PullUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PullUtils.class);
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;
    @Autowired
    private IntAttrNameParser intAttrNameParser;

    public String findMatchingAnyKey(AnyType anyType, String name, ExternalResource resource, Connector connector) {
        Provision provision = resource.getProvision(anyType);
        if (provision == null) {
            return null;
        }
        String result = null;
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyType.getKind());
        final ArrayList found = new ArrayList();
        connector.search(provision.getObjectClass(), (Filter)new EqualsFilter((Attribute)new Name(name)), new ResultsHandler(){

            public boolean handle(ConnectorObject obj) {
                return found.add(obj);
            }
        }, MappingUtils.buildOperationOptions(MappingUtils.getPullItems(provision.getMapping().getItems()).iterator()));
        if (found.isEmpty()) {
            LOG.debug("No {} found on {} with __NAME__ {}", new Object[]{provision.getObjectClass(), resource, name});
        } else {
            if (found.size() > 1) {
                LOG.warn("More than one {} found on {} with __NAME__ {} - taking first only", new Object[]{provision.getObjectClass(), resource, name});
            }
            ConnectorObject connObj = (ConnectorObject)found.iterator().next();
            try {
                List<String> anyKeys = this.findExisting(connObj.getUid().getUidValue(), connObj, provision, anyUtils);
                if (anyKeys.isEmpty()) {
                    LOG.debug("No matching {} found for {}, aborting", (Object)anyUtils.getAnyTypeKind(), (Object)connObj);
                } else {
                    if (anyKeys.size() > 1) {
                        LOG.warn("More than one {} found {} - taking first only", (Object)anyUtils.getAnyTypeKind(), anyKeys);
                    }
                    result = anyKeys.iterator().next();
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn(e.getMessage());
            }
        }
        return result;
    }

    private AnyDAO<?> getAnyDAO(AnyTypeKind anyTypeKind) {
        return AnyTypeKind.USER == anyTypeKind ? this.userDAO : (AnyTypeKind.ANY_OBJECT == anyTypeKind ? this.anyObjectDAO : this.groupDAO);
    }

    private List<String> findByConnObjectKeyItem(String uid, Provision provision, AnyUtils anyUtils) {
        IntAttrName intAttrName;
        MappingItem connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
        String transfUid = uid;
        for (ItemTransformer transformer : MappingUtils.getItemTransformers((Item)connObjectKeyItem)) {
            List output = transformer.beforePull((Item)connObjectKeyItem, null, Collections.singletonList(transfUid));
            if (output == null || output.isEmpty()) continue;
            transfUid = output.get(0).toString();
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            intAttrName = this.intAttrNameParser.parse(connObjectKeyItem.getIntAttrName(), provision.getAnyType().getKind());
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)connObjectKeyItem.getIntAttrName(), (Object)e);
            return result;
        }
        if (intAttrName.getField() != null) {
            switch (intAttrName.getField()) {
                case "key": {
                    Any any = this.getAnyDAO(provision.getAnyType().getKind()).find(transfUid);
                    if (any == null) break;
                    result.add(any.getKey());
                    break;
                }
                case "username": {
                    User user = this.userDAO.findByUsername(transfUid);
                    if (user == null) break;
                    result.add(user.getKey());
                    break;
                }
                case "name": {
                    AnyObject anyObject;
                    Group group = this.groupDAO.findByName(transfUid);
                    if (group != null) {
                        result.add(group.getKey());
                    }
                    if ((anyObject = this.anyObjectDAO.findByName(transfUid)) == null) break;
                    result.add(anyObject.getKey());
                    break;
                }
            }
        } else if (intAttrName.getSchemaType() != null) {
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    PlainAttrValue value = anyUtils.newPlainAttrValue();
                    PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find(intAttrName.getSchemaName());
                    if (schema == null) {
                        value.setStringValue(transfUid);
                    } else {
                        try {
                            value.parseValue(schema, transfUid);
                        }
                        catch (ParsingValidationException e) {
                            LOG.error("While parsing provided __UID__ {}", (Object)transfUid, (Object)e);
                            value.setStringValue(transfUid);
                        }
                    }
                    List anys = this.getAnyDAO(provision.getAnyType().getKind()).findByPlainAttrValue(intAttrName.getSchemaName(), value);
                    for (Any any : anys) {
                        result.add(any.getKey());
                    }
                    break;
                }
                case DERIVED: {
                    List anys = this.getAnyDAO(provision.getAnyType().getKind()).findByDerAttrValue(intAttrName.getSchemaName(), transfUid);
                    for (Any any : anys) {
                        result.add(any.getKey());
                    }
                    break;
                }
            }
        }
        return result;
    }

    private List<String> findByCorrelationRule(ConnectorObject connObj, PullCorrelationRule rule, AnyTypeKind type) {
        ArrayList<String> result = new ArrayList<String>();
        for (Any any : this.searchDAO.search(rule.getSearchCond(connObj), type)) {
            result.add(any.getKey());
        }
        return result;
    }

    private PullCorrelationRule getCorrelationRule(Provision provision, PullPolicySpec policySpec) {
        PullCorrelationRule result = null;
        String pullCorrelationRule = (String)policySpec.getCorrelationRules().get(provision.getAnyType().getKey());
        if (StringUtils.isNotBlank((CharSequence)pullCorrelationRule)) {
            if (pullCorrelationRule.charAt(0) == '[') {
                result = new PlainAttrsPullCorrelationRule((String[])POJOHelper.deserialize((String)pullCorrelationRule, String[].class), provision);
            } else {
                try {
                    result = (PullCorrelationRule)Class.forName(pullCorrelationRule).newInstance();
                }
                catch (Exception e) {
                    LOG.error("Failure instantiating correlation rule class '{}'", (Object)pullCorrelationRule, (Object)e);
                }
            }
        }
        return result;
    }

    public List<String> findExisting(String uid, ConnectorObject connObj, Provision provision, AnyUtils anyUtils) {
        PullPolicySpec pullPolicySpec = null;
        if (provision.getResource().getPullPolicy() != null) {
            pullPolicySpec = provision.getResource().getPullPolicy().getSpecification();
        }
        PullCorrelationRule pullRule = null;
        if (pullPolicySpec != null) {
            pullRule = this.getCorrelationRule(provision, pullPolicySpec);
        }
        try {
            return pullRule == null ? this.findByConnObjectKeyItem(uid, provision, anyUtils) : this.findByCorrelationRule(connObj, pullRule, anyUtils.getAnyTypeKind());
        }
        catch (RuntimeException e) {
            return Collections.emptyList();
        }
    }

    public List<String> findExisting(String uid, ConnectorObject connObj, OrgUnit orgUnit) {
        OrgUnitItem connObjectKeyItem = orgUnit.getConnObjectKeyItem();
        String transfUid = uid;
        for (ItemTransformer transformer : MappingUtils.getItemTransformers((Item)connObjectKeyItem)) {
            List output = transformer.beforePull((Item)connObjectKeyItem, null, Collections.singletonList(transfUid));
            if (output == null || output.isEmpty()) continue;
            transfUid = output.get(0).toString();
        }
        ArrayList<String> result = new ArrayList<String>();
        switch (connObjectKeyItem.getIntAttrName()) {
            case "key": {
                Realm realm = this.realmDAO.find(transfUid);
                if (realm == null) break;
                result.add(realm.getKey());
                break;
            }
            case "name": {
                CollectionUtils.collect((Iterable)this.realmDAO.findByName(transfUid), (Transformer)EntityUtils.keyTransformer(), result);
                break;
            }
            case "fullpath": {
                Realm realm = this.realmDAO.findByFullPath(transfUid);
                if (realm == null) break;
                result.add(realm.getKey());
                break;
            }
        }
        return result;
    }

    public Boolean readEnabled(ConnectorObject connectorObject, ProvisioningTask task) {
        Attribute status;
        Boolean enabled = null;
        if (task.isSyncStatus() && (status = AttributeUtil.find((String)OperationalAttributes.ENABLE_NAME, (Set)connectorObject.getAttributes())) != null && status.getValue() != null && !status.getValue().isEmpty()) {
            enabled = (Boolean)status.getValue().get(0);
        }
        return enabled;
    }
}

