/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.HashMap;
import java.util.Map;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.StringReplacePatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultPullActions;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class GoogleAppsPullActions
extends DefaultPullActions {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleAppsPullActions.class);
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;
    private final Map<String, String> googleAppsIds = new HashMap<String, String>();

    protected String getEmailSchema() {
        return "email";
    }

    protected String getGoogleAppsIdSchema() {
        return "GoogleAppsId";
    }

    @Override
    public void beforeProvision(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity) throws JobExecutionException {
        UserTO userTO;
        if (entity instanceof UserTO && (userTO = (UserTO)entity).getUsername() == null) {
            userTO.setUsername(delta.getObject().getName().getNameValue());
        }
    }

    @Override
    public <P extends AnyPatch> void beforeUpdate(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity, P anyPatch) throws JobExecutionException {
        UserPatch userPatch;
        if (anyPatch instanceof UserPatch && (userPatch = (UserPatch)anyPatch).getUsername() == null) {
            userPatch.setUsername((StringReplacePatchItem)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value((Object)delta.getObject().getName().getNameValue())).build());
        }
    }

    @Override
    @Transactional
    public void after(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity, ProvisioningReport result) throws JobExecutionException {
        if (!(entity instanceof UserTO)) {
            return;
        }
        this.googleAppsIds.put(entity.getKey(), delta.getUid().getUidValue());
    }

    @Override
    @Transactional
    public void afterAll(ProvisioningProfile<?, ?> profile) throws JobExecutionException {
        for (Map.Entry<String, String> entry : this.googleAppsIds.entrySet()) {
            User user = (User)this.userDAO.find(entry.getKey());
            if (user == null) {
                LOG.error("Could not find user {}, skipping", (Object)entry.getKey());
                continue;
            }
            AnyUtils anyUtils = this.anyUtilsFactory.getInstance((Any)user);
            PlainSchema googleAppsId = (PlainSchema)this.plainSchemaDAO.find(this.getGoogleAppsIdSchema());
            if (googleAppsId == null) {
                LOG.error("Could not find schema googleAppsId, skipping");
                continue;
            }
            UPlainAttr attr = (UPlainAttr)user.getPlainAttr(this.getGoogleAppsIdSchema());
            if (attr == null) {
                attr = (UPlainAttr)this.entityFactory.newEntity(UPlainAttr.class);
                attr.setSchema(googleAppsId);
                attr.setOwner((Any)user);
                user.add((GroupablePlainAttr)attr);
                try {
                    attr.add(entry.getValue(), anyUtils);
                    this.userDAO.save((Any)user);
                }
                catch (InvalidPlainAttrValueException e) {
                    LOG.error("Invalid value for attribute {}: {}", new Object[]{googleAppsId.getKey(), entry.getValue(), e});
                }
                continue;
            }
            LOG.debug("User {} has already a googleAppsId assigned: {}", (Object)user, (Object)attr.getValuesAsStrings());
        }
    }
}

