/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractPushResultHandler;

public class DefaultUserPushResultHandler
extends AbstractPushResultHandler
implements UserPushResultHandler {
    @Override
    protected AnyUtils getAnyUtils() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
    }

    @Override
    protected void provision(Any<?> any, Boolean enabled, ProvisioningReport result) {
        AnyTO before = this.getAnyTO(any.getKey());
        ArrayList noPropResources = new ArrayList(before.getResources());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.CREATE, ((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationReporter reporter = this.taskExecutor.execute((Collection)this.propagationManager.getUserCreateTasks(before.getKey(), null, enabled, propByRes, (Collection)before.getVirAttrs(), noPropResources), false);
        this.reportPropagation(result, reporter);
    }

    @Override
    protected String getName(Any<?> any) {
        return ((User)User.class.cast(any)).getUsername();
    }

    @Override
    protected Any<?> getAny(String key) {
        try {
            return this.userDAO.authFind(key);
        }
        catch (Exception e) {
            LOG.warn("Error retrieving user {}", (Object)key, (Object)e);
            return null;
        }
    }

    @Override
    protected AnyTO getAnyTO(String key) {
        return this.userDataBinder.getUserTO(key);
    }

    @Override
    protected AnyPatch newPatch(String key) {
        UserPatch patch = new UserPatch();
        patch.setKey(key);
        return patch;
    }

    @Override
    protected WorkflowResult<? extends AnyPatch> update(AnyPatch patch) {
        WorkflowResult update = this.uwfAdapter.update((UserPatch)patch);
        return new WorkflowResult(((Pair)update.getResult()).getLeft(), update.getPropByRes(), update.getPerformedTasks());
    }
}

