/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractRealmResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.PullUtils;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class DefaultRealmPullResultHandler
extends AbstractRealmResultHandler<PullTask, PullActions>
implements RealmPullResultHandler {
    @Autowired
    private PullUtils pullUtils;
    @Autowired
    private ConnObjectUtils connObjectUtils;
    @Autowired
    private AnySearchDAO searchDAO;
    private SyncopePullExecutor executor;
    private AuditElements.Result latestResult;

    public void setPullExecutor(SyncopePullExecutor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(SyncDelta delta) {
        try {
            boolean shouldContinue;
            OrgUnit orgUnit = ((PullTask)this.profile.getTask()).getResource().getOrgUnit();
            if (orgUnit == null) {
                throw new JobExecutionException("No orgUnit found on " + ((PullTask)this.profile.getTask()).getResource() + " for " + delta.getObject().getObjectClass());
            }
            this.doHandle(delta, orgUnit);
            this.executor.reportHandled(delta.getObjectClass(), delta.getObject().getName());
            LOG.debug("Successfully handled {}", (Object)delta);
            if (((PullTask)this.profile.getTask()).getPullMode() != PullMode.INCREMENTAL) {
                return true;
            }
            DefaultRealmPullResultHandler defaultRealmPullResultHandler = this;
            synchronized (defaultRealmPullResultHandler) {
                shouldContinue = this.latestResult == AuditElements.Result.SUCCESS;
                this.latestResult = null;
            }
            if (shouldContinue) {
                this.executor.setLatestSyncToken(delta.getObjectClass(), delta.getToken());
            }
            return shouldContinue;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport ignoreResult = new ProvisioningReport();
            ignoreResult.setOperation(ResourceOperation.NONE);
            ignoreResult.setStatus(ProvisioningReport.Status.IGNORE);
            ignoreResult.setAnyType("REALM");
            ignoreResult.setKey(null);
            ignoreResult.setName(delta.getObject().getName().getNameValue());
            this.profile.getResults().add(ignoreResult);
            LOG.warn("Ignoring during pull", (Throwable)e);
            this.executor.setLatestSyncToken(delta.getObjectClass(), delta.getToken());
            this.executor.reportHandled(delta.getObjectClass(), delta.getObject().getName());
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Pull failed", (Throwable)e);
            return false;
        }
    }

    private List<ProvisioningReport> assign(SyncDelta delta, OrgUnit orgUnit) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("PullTask not configured for create");
            this.finalize(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.ASSIGN), AuditElements.Result.SUCCESS, null, null, delta);
            return Collections.emptyList();
        }
        RealmTO realmTO = this.connObjectUtils.getRealmTO(delta.getObject(), (PullTask)this.profile.getTask(), orgUnit);
        if (realmTO.getFullPath() == null) {
            if (realmTO.getParent() == null) {
                realmTO.setParent(((PullTask)this.profile.getTask()).getDestinatioRealm().getFullPath());
            }
            realmTO.setFullPath(realmTO.getParent() + "/" + realmTO.getName());
        }
        realmTO.getResources().add(((PullTask)this.profile.getTask()).getResource().getKey());
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType("REALM");
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(realmTO.getFullPath());
        if (this.profile.isDryRun()) {
            result.setKey(null);
            this.finalize(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.ASSIGN), AuditElements.Result.SUCCESS, null, null, delta);
        } else {
            for (PullActions action : this.profile.getActions()) {
                action.beforeAssign(this.profile, delta, (EntityTO)realmTO);
            }
            this.create(realmTO, delta, UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.ASSIGN), result);
        }
        return Collections.singletonList(result);
    }

    private List<ProvisioningReport> provision(SyncDelta delta, OrgUnit orgUnit) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("PullTask not configured for create");
            this.finalize(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.PROVISION), AuditElements.Result.SUCCESS, null, null, delta);
            return Collections.emptyList();
        }
        RealmTO realmTO = this.connObjectUtils.getRealmTO(delta.getObject(), (PullTask)this.profile.getTask(), orgUnit);
        if (realmTO.getFullPath() == null) {
            if (realmTO.getParent() == null) {
                realmTO.setParent(((PullTask)this.profile.getTask()).getDestinatioRealm().getFullPath());
            }
            realmTO.setFullPath(realmTO.getParent() + "/" + realmTO.getName());
        }
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType("REALM");
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(realmTO.getFullPath());
        if (this.profile.isDryRun()) {
            result.setKey(null);
            this.finalize(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.PROVISION), AuditElements.Result.SUCCESS, null, null, delta);
        } else {
            for (PullActions action : this.profile.getActions()) {
                action.beforeProvision(this.profile, delta, (EntityTO)realmTO);
            }
            this.create(realmTO, delta, UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.PROVISION), result);
        }
        return Collections.singletonList(result);
    }

    private void throwIgnoreProvisionException(SyncDelta delta, Exception exception) throws JobExecutionException {
        if (exception instanceof IgnoreProvisionException) {
            throw (IgnoreProvisionException)((Object)IgnoreProvisionException.class.cast(exception));
        }
        IgnoreProvisionException ipe = null;
        for (PullActions action : this.profile.getActions()) {
            if (ipe != null) continue;
            ipe = action.onError(this.profile, delta, exception);
        }
        if (ipe != null) {
            throw ipe;
        }
    }

    private void create(RealmTO realmTO, SyncDelta delta, String operation, ProvisioningReport result) throws JobExecutionException {
        AuditElements.Result resultStatus;
        Throwable output;
        try {
            Realm realm = this.realmDAO.save(this.binder.create(((PullTask)this.profile.getTask()).getDestinatioRealm(), realmTO));
            PropagationByResource propByRes = new PropagationByResource();
            for (String resource : realm.getResourceKeys()) {
                propByRes.add(ResourceOperation.CREATE, resource);
            }
            List tasks = this.propagationManager.createTasks(realm, propByRes, null);
            this.taskExecutor.execute((Collection)tasks, false);
            RealmTO actual = this.binder.getRealmTO(realm, true);
            result.setKey(actual.getKey());
            result.setName(((PullTask)this.profile.getTask()).getDestinatioRealm().getFullPath() + "/" + actual.getName());
            output = actual;
            resultStatus = AuditElements.Result.SUCCESS;
            for (PullActions action : this.profile.getActions()) {
                action.after(this.profile, delta, (EntityTO)actual, result);
            }
            LOG.debug("Realm {} successfully created", (Object)actual.getKey());
        }
        catch (PropagationException e) {
            LOG.error("Could not propagate Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
            output = e;
            resultStatus = AuditElements.Result.FAILURE;
        }
        catch (Exception e) {
            this.throwIgnoreProvisionException(delta, e);
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOG.error("Could not create Realm {} ", (Object)delta.getUid().getUidValue(), (Object)e);
            output = e;
            resultStatus = AuditElements.Result.FAILURE;
        }
        this.finalize(operation, resultStatus, null, output, delta);
    }

    private List<ProvisioningReport> update(SyncDelta delta, List<String> keys) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.finalize(MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), AuditElements.Result.SUCCESS, null, null, delta);
            return Collections.emptyList();
        }
        LOG.debug("About to update {}", keys);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (String key : keys) {
            LOG.debug("About to update {}", (Object)key);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.UPDATE);
            result.setAnyType("REALM");
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(key);
            Realm realm = this.realmDAO.find(key);
            RealmTO before = this.binder.getRealmTO(realm, true);
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Realm '%s' not found", key));
            } else {
                result.setName(before.getFullPath());
            }
            if (!this.profile.isDryRun()) {
                Throwable output;
                AuditElements.Result resultStatus;
                if (before == null) {
                    resultStatus = AuditElements.Result.FAILURE;
                    output = null;
                } else {
                    try {
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeUpdate(this.profile, delta, (EntityTO)before, null);
                        }
                        PropagationByResource propByRes = this.binder.update(realm, before);
                        realm = this.realmDAO.save(realm);
                        RealmTO updated = this.binder.getRealmTO(realm, true);
                        List tasks = this.propagationManager.createTasks(realm, propByRes, null);
                        this.taskExecutor.execute((Collection)tasks, false);
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)updated, result);
                        }
                        output = updated;
                        resultStatus = AuditElements.Result.SUCCESS;
                        result.setName(updated.getFullPath());
                        LOG.debug("{} successfully updated", (Object)updated);
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                }
                this.finalize(MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), resultStatus, before, output, delta);
            }
            results.add(result);
        }
        return results;
    }

    private List<ProvisioningReport> deprovision(SyncDelta delta, List<String> keys, boolean unlink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.finalize(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNASSIGN) : MatchingRule.toEventName((MatchingRule)MatchingRule.DEPROVISION), AuditElements.Result.SUCCESS, null, null, delta);
            return Collections.emptyList();
        }
        LOG.debug("About to deprovision {}", keys);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (String key : keys) {
            LOG.debug("About to unassign resource {}", (Object)key);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.DELETE);
            result.setAnyType("REALM");
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(key);
            Realm realm = this.realmDAO.find(key);
            RealmTO before = this.binder.getRealmTO(realm, true);
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Realm '%s' not found", key));
            } else {
                result.setName(before.getFullPath());
            }
            if (!this.profile.isDryRun()) {
                Throwable output;
                AuditElements.Result resultStatus;
                if (before == null) {
                    resultStatus = AuditElements.Result.FAILURE;
                    output = null;
                } else {
                    try {
                        if (unlink) {
                            for (PullActions action : this.profile.getActions()) {
                                action.beforeUnassign(this.profile, delta, (EntityTO)before);
                            }
                        } else {
                            for (PullActions action : this.profile.getActions()) {
                                action.beforeDeprovision(this.profile, delta, (EntityTO)before);
                            }
                        }
                        PropagationByResource propByRes = new PropagationByResource();
                        propByRes.add(ResourceOperation.DELETE, ((PullTask)this.profile.getTask()).getResource().getKey());
                        this.taskExecutor.execute((Collection)this.propagationManager.createTasks(realm, propByRes, null), false);
                        if (unlink) {
                            realm.getResources().remove(((PullTask)this.profile.getTask()).getResource());
                            output = this.binder.getRealmTO(this.realmDAO.save(realm), true);
                        } else {
                            output = this.binder.getRealmTO(realm, true);
                        }
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)RealmTO.class.cast(output), result);
                        }
                        resultStatus = AuditElements.Result.SUCCESS;
                        LOG.debug("{} successfully updated", (Object)realm);
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                }
                this.finalize(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNASSIGN) : MatchingRule.toEventName((MatchingRule)MatchingRule.DEPROVISION), resultStatus, before, output, delta);
            }
            results.add(result);
        }
        return results;
    }

    private List<ProvisioningReport> link(SyncDelta delta, List<String> keys, boolean unlink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.finalize(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toEventName((MatchingRule)MatchingRule.LINK), AuditElements.Result.SUCCESS, null, null, delta);
            return Collections.emptyList();
        }
        LOG.debug("About to link {}", keys);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (String key : keys) {
            LOG.debug("About to unassign resource {}", (Object)key);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.NONE);
            result.setAnyType("REALM");
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(key);
            Realm realm = this.realmDAO.find(key);
            RealmTO before = this.binder.getRealmTO(realm, true);
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Realm '%s' not found", key));
            } else {
                result.setName(before.getFullPath());
            }
            if (!this.profile.isDryRun()) {
                Object output;
                AuditElements.Result resultStatus;
                if (before == null) {
                    resultStatus = AuditElements.Result.FAILURE;
                    output = null;
                } else {
                    try {
                        if (unlink) {
                            for (PullActions action : this.profile.getActions()) {
                                action.beforeUnlink(this.profile, delta, (EntityTO)before);
                            }
                        } else {
                            for (PullActions action : this.profile.getActions()) {
                                action.beforeLink(this.profile, delta, (EntityTO)before);
                            }
                        }
                        if (unlink) {
                            realm.getResources().remove(((PullTask)this.profile.getTask()).getResource());
                        } else {
                            realm.add(((PullTask)this.profile.getTask()).getResource());
                        }
                        output = this.update(delta, Collections.singletonList(key));
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)RealmTO.class.cast(output), result);
                        }
                        resultStatus = AuditElements.Result.SUCCESS;
                        LOG.debug("{} successfully updated", (Object)realm);
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update Realm {}", (Object)delta.getUid().getUidValue(), (Object)e);
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                }
                this.finalize(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toEventName((MatchingRule)MatchingRule.LINK), resultStatus, before, output, delta);
            }
            results.add(result);
        }
        return results;
    }

    private List<ProvisioningReport> delete(SyncDelta delta, List<String> keys) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformDelete()) {
            LOG.debug("PullTask not configured for delete");
            this.finalize(ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, delta);
            return Collections.emptyList();
        }
        LOG.debug("About to delete {}", keys);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (String key : keys) {
            AuditElements.Result resultStatus = AuditElements.Result.FAILURE;
            ProvisioningReport result = new ProvisioningReport();
            try {
                result.setKey(key);
                result.setOperation(ResourceOperation.DELETE);
                result.setAnyType("REALM");
                result.setStatus(ProvisioningReport.Status.SUCCESS);
                Realm realm = this.realmDAO.find(key);
                RealmTO before = this.binder.getRealmTO(realm, true);
                if (before == null) {
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(String.format("Realm '%s' not found", key));
                } else {
                    result.setName(before.getFullPath());
                }
                if (!this.profile.isDryRun()) {
                    Exception output;
                    for (PullActions action : this.profile.getActions()) {
                        action.beforeDelete(this.profile, delta, (EntityTO)before);
                    }
                    try {
                        if (!this.realmDAO.findChildren(realm).isEmpty()) {
                            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.HasChildren);
                        }
                        Set<String> adminRealms = Collections.singleton(realm.getFullPath());
                        AnyCond keyCond = new AnyCond(AttributeCond.Type.ISNOTNULL);
                        keyCond.setSchema("key");
                        SearchCond allMatchingCond = SearchCond.getLeafCond((AttributeCond)keyCond);
                        int users = this.searchDAO.count(adminRealms, allMatchingCond, AnyTypeKind.USER);
                        int groups = this.searchDAO.count(adminRealms, allMatchingCond, AnyTypeKind.GROUP);
                        int anyObjects = this.searchDAO.count(adminRealms, allMatchingCond, AnyTypeKind.ANY_OBJECT);
                        if (users + groups + anyObjects > 0) {
                            SyncopeClientException containedAnys = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.AssociatedAnys);
                            containedAnys.getElements().add(users + " user(s)");
                            containedAnys.getElements().add(groups + " group(s)");
                            containedAnys.getElements().add(anyObjects + " anyObject(s)");
                            throw containedAnys;
                        }
                        PropagationByResource propByRes = new PropagationByResource();
                        for (String resource : realm.getResourceKeys()) {
                            propByRes.add(ResourceOperation.DELETE, resource);
                        }
                        List tasks = this.propagationManager.createTasks(realm, propByRes, null);
                        this.taskExecutor.execute((Collection)tasks, false);
                        this.realmDAO.delete(realm);
                        output = null;
                        resultStatus = AuditElements.Result.SUCCESS;
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)before, result);
                        }
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not delete {}", (Object)realm, (Object)e);
                        output = e;
                    }
                    this.finalize(ResourceOperation.DELETE.name().toLowerCase(), resultStatus, before, output, delta);
                }
                results.add(result);
            }
            catch (DelegatedAdministrationException e) {
                LOG.error("Not allowed to read Realm {}", (Object)key, (Object)e);
            }
            catch (Exception e) {
                LOG.error("Could not delete Realm {}", (Object)key, (Object)e);
            }
        }
        return results;
    }

    private ProvisioningReport ignore(SyncDelta delta, boolean matching) throws JobExecutionException {
        LOG.debug("Any to ignore {}", (Object)delta.getObject().getUid().getUidValue());
        ProvisioningReport result = new ProvisioningReport();
        result.setKey(null);
        result.setName(delta.getObject().getUid().getUidValue());
        result.setOperation(ResourceOperation.NONE);
        result.setAnyType("REALM");
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        if (!this.profile.isDryRun()) {
            this.finalize(matching ? MatchingRule.toEventName((MatchingRule)MatchingRule.IGNORE) : UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.IGNORE), AuditElements.Result.SUCCESS, null, null, delta);
        }
        return result;
    }

    private void doHandle(SyncDelta delta, OrgUnit orgUnit) throws JobExecutionException {
        LOG.debug("Process {} for {} as {}", new Object[]{delta.getDeltaType(), delta.getUid().getUidValue(), delta.getObject().getObjectClass()});
        SyncDelta processed = delta;
        for (PullActions action : this.profile.getActions()) {
            processed = action.preprocess(this.profile, processed);
        }
        LOG.debug("Transformed {} for {} as {}", new Object[]{processed.getDeltaType(), processed.getUid().getUidValue(), processed.getObject().getObjectClass()});
        String uid = processed.getPreviousUid() == null ? processed.getUid().getUidValue() : processed.getPreviousUid().getUidValue();
        List<String> keys = this.pullUtils.findExisting(uid, processed.getObject(), orgUnit);
        LOG.debug("Match found for {} as {}: {}", new Object[]{processed.getUid().getUidValue(), processed.getObject().getObjectClass(), keys});
        if (keys.size() > 1) {
            switch (this.profile.getResAct()) {
                case IGNORE: {
                    throw new IllegalStateException("More than one match " + keys);
                }
                case FIRSTMATCH: {
                    keys = keys.subList(0, 1);
                    break;
                }
                case LASTMATCH: {
                    keys = keys.subList(keys.size() - 1, keys.size());
                    break;
                }
            }
        }
        try {
            if (SyncDeltaType.CREATE_OR_UPDATE == processed.getDeltaType()) {
                if (keys.isEmpty()) {
                    switch (((PullTask)this.profile.getTask()).getUnmatchingRule()) {
                        case ASSIGN: {
                            this.profile.getResults().addAll(this.assign(processed, orgUnit));
                            break;
                        }
                        case PROVISION: {
                            this.profile.getResults().addAll(this.provision(processed, orgUnit));
                            break;
                        }
                        case IGNORE: {
                            this.profile.getResults().add(this.ignore(processed, false));
                            break;
                        }
                    }
                } else {
                    switch (((PullTask)this.profile.getTask()).getMatchingRule()) {
                        case UPDATE: {
                            this.profile.getResults().addAll(this.update(processed, keys));
                            break;
                        }
                        case DEPROVISION: {
                            this.profile.getResults().addAll(this.deprovision(processed, keys, false));
                            break;
                        }
                        case UNASSIGN: {
                            this.profile.getResults().addAll(this.deprovision(processed, keys, true));
                            break;
                        }
                        case LINK: {
                            this.profile.getResults().addAll(this.link(processed, keys, false));
                            break;
                        }
                        case UNLINK: {
                            this.profile.getResults().addAll(this.link(processed, keys, true));
                            break;
                        }
                        case IGNORE: {
                            this.profile.getResults().add(this.ignore(processed, true));
                            break;
                        }
                    }
                }
            } else if (SyncDeltaType.DELETE == processed.getDeltaType()) {
                if (keys.isEmpty()) {
                    this.finalize(ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, processed);
                    LOG.debug("No match found for deletion");
                } else {
                    this.profile.getResults().addAll(this.delete(processed, keys));
                }
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LOG.warn(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalize(String event, AuditElements.Result result, Object before, Object output, SyncDelta delta) {
        DefaultRealmPullResultHandler defaultRealmPullResultHandler = this;
        synchronized (defaultRealmPullResultHandler) {
            this.latestResult = result;
        }
        this.notificationManager.createTasks(AuditElements.EventCategoryType.PULL, "REALM".toLowerCase(), ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta});
        this.auditManager.audit(AuditElements.EventCategoryType.PULL, "REALM".toLowerCase(), ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta});
    }
}

