/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.GroupProvisioningManager;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractPullResultHandler;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultGroupPullResultHandler
extends AbstractPullResultHandler
implements GroupPullResultHandler {
    @Autowired
    private GroupProvisioningManager groupProvisioningManager;
    private final Map<String, String> groupOwnerMap = new HashMap<String, String>();

    public Map<String, String> getGroupOwnerMap() {
        return this.groupOwnerMap;
    }

    @Override
    protected AnyUtils getAnyUtils() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP);
    }

    @Override
    protected String getName(AnyTO anyTO) {
        return ((GroupTO)GroupTO.class.cast(anyTO)).getName();
    }

    @Override
    protected ProvisioningManager<?, ?> getProvisioningManager() {
        return this.groupProvisioningManager;
    }

    @Override
    protected Any<?> getAny(String key) {
        try {
            return this.groupDAO.authFind(key);
        }
        catch (Exception e) {
            LOG.warn("Error retrieving group {}", (Object)key, (Object)e);
            return null;
        }
    }

    @Override
    protected AnyTO getAnyTO(String key) {
        return this.groupDataBinder.getGroupTO(key);
    }

    @Override
    protected AnyPatch newPatch(String key) {
        GroupPatch patch = new GroupPatch();
        patch.setKey(key);
        return patch;
    }

    @Override
    protected WorkflowResult<? extends AnyPatch> update(AnyPatch patch) {
        return this.gwfAdapter.update((GroupPatch)patch);
    }

    @Override
    protected AnyTO doCreate(AnyTO anyTO, SyncDelta delta) {
        GroupTO groupTO = (GroupTO)GroupTO.class.cast(anyTO);
        Pair created = this.groupProvisioningManager.create(groupTO, this.groupOwnerMap, Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
        return this.getAnyTO((String)created.getKey());
    }

    @Override
    protected AnyPatch doUpdate(AnyTO before, AnyPatch anyPatch, SyncDelta delta, ProvisioningReport result) {
        GroupPatch groupPatch = (GroupPatch)GroupPatch.class.cast(anyPatch);
        Pair updated = this.groupProvisioningManager.update((AnyPatch)groupPatch, Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
        String groupOwner = null;
        for (AttrPatch attrPatch : groupPatch.getPlainAttrs()) {
            if (attrPatch.getOperation() != PatchOperation.ADD_REPLACE || attrPatch.getAttrTO() == null || !attrPatch.getAttrTO().getSchema().isEmpty() || attrPatch.getAttrTO().getValues().isEmpty()) continue;
            groupOwner = (String)attrPatch.getAttrTO().getValues().get(0);
        }
        if (groupOwner != null) {
            this.groupOwnerMap.put(((GroupPatch)updated.getLeft()).getKey(), groupOwner);
        }
        return anyPatch;
    }
}

