/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Collections;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.pushpull.AnyObjectPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractPullResultHandler;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultAnyObjectPullResultHandler
extends AbstractPullResultHandler
implements AnyObjectPullResultHandler {
    @Autowired
    private AnyObjectProvisioningManager anyObjectProvisioningManager;

    @Override
    protected AnyUtils getAnyUtils() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT);
    }

    @Override
    protected String getName(AnyTO anyTO) {
        return ((AnyObjectTO)AnyObjectTO.class.cast(anyTO)).getName();
    }

    @Override
    protected ProvisioningManager<?, ?> getProvisioningManager() {
        return this.anyObjectProvisioningManager;
    }

    @Override
    protected Any<?> getAny(String key) {
        try {
            return this.anyObjectDAO.authFind(key);
        }
        catch (Exception e) {
            LOG.warn("Error retrieving anyObject {}", (Object)key, (Object)e);
            return null;
        }
    }

    @Override
    protected AnyTO getAnyTO(String key) {
        return this.anyObjectDataBinder.getAnyObjectTO(key);
    }

    @Override
    protected AnyPatch newPatch(String key) {
        AnyObjectPatch patch = new AnyObjectPatch();
        patch.setKey(key);
        return patch;
    }

    @Override
    protected WorkflowResult<? extends AnyPatch> update(AnyPatch patch) {
        return this.awfAdapter.update((AnyObjectPatch)patch);
    }

    @Override
    protected AnyTO doCreate(AnyTO anyTO, SyncDelta delta) {
        AnyObjectTO anyObjectTO = (AnyObjectTO)AnyObjectTO.class.cast(anyTO);
        Pair created = this.anyObjectProvisioningManager.create(anyObjectTO, Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
        return this.getAnyTO((String)created.getKey());
    }

    @Override
    protected AnyPatch doUpdate(AnyTO before, AnyPatch anyPatch, SyncDelta delta, ProvisioningReport result) {
        AnyObjectPatch anyObjectPatch = (AnyObjectPatch)AnyObjectPatch.class.cast(anyPatch);
        Pair updated = this.anyObjectProvisioningManager.update((AnyPatch)anyObjectPatch, Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
        return anyPatch;
    }
}

