/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.PropagationTaskExecStatus;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.TimeoutException;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.java.job.AfterHandlingJob;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractSyncopeResultHandler;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractPushResultHandler
extends AbstractSyncopeResultHandler<PushTask, PushActions>
implements SyncopePushResultHandler {
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected MappingManager mappingManager;
    @Autowired
    protected SchedulerFactoryBean scheduler;

    protected abstract String getName(Any<?> var1);

    protected void reportPropagation(ProvisioningReport result, PropagationReporter reporter) {
        if (!reporter.getStatuses().isEmpty()) {
            result.setStatus(this.toProvisioningReportStatus(((PropagationStatus)reporter.getStatuses().get(0)).getStatus()));
            result.setMessage(((PropagationStatus)reporter.getStatuses().get(0)).getFailureReason());
        }
    }

    protected void update(Any<?> any, ProvisioningReport result) {
        Collection resourceKeys;
        boolean changepwd;
        if (any instanceof User) {
            changepwd = true;
            resourceKeys = this.userDAO.findAllResourceKeys(any.getKey());
        } else if (any instanceof AnyObject) {
            changepwd = false;
            resourceKeys = this.anyObjectDAO.findAllResourceKeys(any.getKey());
        } else {
            changepwd = false;
            resourceKeys = this.groupDAO.findAllResourceKeys(any.getKey());
        }
        ArrayList noPropResources = new ArrayList(resourceKeys);
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.CREATE, ((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationReporter reporter = this.taskExecutor.execute((Collection)this.propagationManager.getUpdateTasks(any.getType().getKind(), any.getKey(), changepwd, null, propByRes, null, noPropResources), false);
        this.reportPropagation(result, reporter);
    }

    protected void deprovision(Any<?> any, ProvisioningReport result) {
        AnyTO before = this.getAnyTO(any.getKey());
        ArrayList noPropResources = new ArrayList(before.getResources());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationReporter reporter = this.taskExecutor.execute((Collection)this.propagationManager.getDeleteTasks(any.getType().getKind(), any.getKey(), null, noPropResources), false);
        this.reportPropagation(result, reporter);
    }

    protected void provision(Any<?> any, Boolean enabled, ProvisioningReport result) {
        AnyTO before = this.getAnyTO(any.getKey());
        ArrayList noPropResources = new ArrayList(before.getResources());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.CREATE, ((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationReporter reporter = this.taskExecutor.execute((Collection)this.propagationManager.getCreateTasks(any.getType().getKind(), any.getKey(), propByRes, (Collection)before.getVirAttrs(), noPropResources), false);
        this.reportPropagation(result, reporter);
    }

    protected void link(Any<?> any, boolean unlink, ProvisioningReport result) {
        AnyPatch patch = this.newPatch(any.getKey());
        patch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(unlink ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE)).value((Object)((PushTask)this.profile.getTask()).getResource().getKey())).build());
        this.update(patch);
        result.setStatus(ProvisioningReport.Status.SUCCESS);
    }

    protected void unassign(Any<?> any, ProvisioningReport result) {
        AnyPatch patch = this.newPatch(any.getKey());
        patch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value((Object)((PushTask)this.profile.getTask()).getResource().getKey())).build());
        this.update(patch);
        this.deprovision(any, result);
    }

    protected void assign(Any<?> any, Boolean enabled, ProvisioningReport result) {
        AnyPatch patch = this.newPatch(any.getKey());
        patch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value((Object)((PushTask)this.profile.getTask()).getResource().getKey())).build());
        this.update(patch);
        this.provision(any, enabled, result);
    }

    protected ConnectorObject getRemoteObject(ObjectClass objectClass, String connObjectKey, String connObjectKeyValue, Iterator<? extends Item> iterator) {
        ConnectorObject obj = null;
        try {
            obj = this.profile.getConnector().getObject(objectClass, AttributeBuilder.build((String)connObjectKey, (Object[])new Object[]{connObjectKeyValue}), MappingUtils.buildOperationOptions(iterator));
        }
        catch (TimeoutException toe) {
            LOG.debug("Request timeout", (Throwable)toe);
            throw toe;
        }
        catch (RuntimeException ignore) {
            LOG.debug("While resolving {}", (Object)connObjectKeyValue, (Object)ignore);
        }
        return obj;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean handle(String anyKey) {
        Any<?> any = null;
        try {
            any = this.getAny(anyKey);
            this.doHandle(any);
            return true;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.NONE);
            result.setAnyType(any == null ? null : any.getType().getKey());
            result.setStatus(ProvisioningReport.Status.IGNORE);
            result.setKey(anyKey);
            this.profile.getResults().add(result);
            LOG.warn("Ignoring during push", (Throwable)e);
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Push failed", (Throwable)e);
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doHandle(Any<?> any) throws JobExecutionException {
        HashMap<String, Object> jobMap;
        Boolean status;
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(any);
        ProvisioningReport result = new ProvisioningReport();
        this.profile.getResults().add(result);
        result.setKey(any.getKey());
        result.setAnyType(any.getType().getKey());
        result.setName(this.getName(any));
        Boolean enabled = any instanceof User && ((PushTask)this.profile.getTask()).isSyncStatus() ? (((User)any).isSuspended().booleanValue() ? Boolean.FALSE : Boolean.TRUE) : null;
        LOG.debug("Propagating {} with key {} towards {}", new Object[]{anyUtils.getAnyTypeKind(), any.getKey(), ((PushTask)this.profile.getTask()).getResource()});
        Exception output = null;
        AuditElements.Result resultStatus = null;
        Provision provision = ((PushTask)this.profile.getTask()).getResource().getProvision(any.getType());
        MappingItem connObjectKey = MappingUtils.getConnObjectKeyItem(provision);
        String connObjecKeyValue = this.mappingManager.getConnObjectKeyValue(any, provision);
        ConnectorObject beforeObj = this.getRemoteObject(provision.getObjectClass(), connObjectKey.getExtAttrName(), connObjecKeyValue, provision.getMapping().getItems().iterator());
        Boolean bl = status = ((PushTask)this.profile.getTask()).isSyncStatus() ? enabled : null;
        if (this.profile.isDryRun()) {
            if (beforeObj == null) {
                result.setOperation(this.toResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
            } else {
                result.setOperation(this.toResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
            }
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            return;
        }
        String operation = beforeObj == null ? UnmatchingRule.toEventName((UnmatchingRule)((PushTask)this.profile.getTask()).getUnmatchingRule()) : MatchingRule.toEventName((MatchingRule)((PushTask)this.profile.getTask()).getMatchingRule());
        boolean notificationsAvailable = this.notificationManager.notificationsAvailable(AuditElements.EventCategoryType.PUSH, any.getType().getKind().name().toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation);
        boolean auditRequested = this.auditManager.auditRequested(AuditElements.EventCategoryType.PUSH, any.getType().getKind().name().toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation);
        try {
            if (beforeObj == null) {
                result.setOperation(this.toResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
                switch (((PushTask)this.profile.getTask()).getUnmatchingRule()) {
                    case ASSIGN: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeAssign(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                            LOG.debug("PushTask not configured for create");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.assign(any, status, result);
                        break;
                    }
                    case PROVISION: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeProvision(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                            LOG.debug("PushTask not configured for create");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.provision(any, status, result);
                        break;
                    }
                    case UNLINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(any, true, result);
                        break;
                    }
                    case IGNORE: {
                        LOG.debug("Ignored any: {}", any);
                        result.setStatus(ProvisioningReport.Status.IGNORE);
                        break;
                    }
                }
            } else {
                result.setOperation(this.toResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
                switch (((PushTask)this.profile.getTask()).getMatchingRule()) {
                    case UPDATE: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUpdate(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.update(any, result);
                        break;
                    }
                    case DEPROVISION: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeDeprovision(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                            LOG.debug("PushTask not configured for delete");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.deprovision(any, result);
                        break;
                    }
                    case UNASSIGN: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnassign(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                            LOG.debug("PushTask not configured for delete");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.unassign(any, result);
                        break;
                    }
                    case LINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeLink(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(any, false, result);
                        break;
                    }
                    case UNLINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(any, true, result);
                        break;
                    }
                    case IGNORE: {
                        LOG.debug("Ignored any: {}", any);
                        result.setStatus(ProvisioningReport.Status.IGNORE);
                        break;
                    }
                }
            }
            for (PushActions action : this.profile.getActions()) {
                action.after(this.profile, any, result);
            }
            if (result.getStatus() == null) {
                result.setStatus(ProvisioningReport.Status.SUCCESS);
            }
            resultStatus = AuditElements.Result.SUCCESS;
            output = this.getRemoteObject(provision.getObjectClass(), connObjectKey.getExtAttrName(), connObjecKeyValue, provision.getMapping().getItems().iterator());
            if (!notificationsAvailable) {
                if (!auditRequested) return;
            }
            jobMap = new HashMap<String, Object>();
        }
        catch (IgnoreProvisionException e) {
            try {
                throw e;
                catch (Exception e2) {
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e2));
                    resultStatus = AuditElements.Result.FAILURE;
                    output = e2;
                    LOG.warn("Error pushing {} towards {}", new Object[]{any, ((PushTask)this.profile.getTask()).getResource(), e2});
                    Iterator iterator = this.profile.getActions().iterator();
                    while (iterator.hasNext()) {
                        PushActions action = (PushActions)iterator.next();
                        action.onError(this.profile, any, result, e2);
                    }
                    throw new JobExecutionException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (!notificationsAvailable) {
                    if (!auditRequested) throw throwable;
                }
                HashMap<String, Object> jobMap2 = new HashMap<String, Object>();
                jobMap2.put("AfterHandlingEvent", new AfterHandlingEvent(AuditElements.EventCategoryType.PUSH, any.getType().getKind().name().toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, (Object)output, new Object[]{any}));
                AfterHandlingJob.schedule(this.scheduler, jobMap2);
                throw throwable;
            }
        }
        jobMap.put("AfterHandlingEvent", new AfterHandlingEvent(AuditElements.EventCategoryType.PUSH, any.getType().getKind().name().toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, (Object)output, new Object[]{any}));
        AfterHandlingJob.schedule(this.scheduler, jobMap);
    }

    protected ResourceOperation toResourceOperation(UnmatchingRule rule) {
        switch (rule) {
            case ASSIGN: 
            case PROVISION: {
                return ResourceOperation.CREATE;
            }
        }
        return ResourceOperation.NONE;
    }

    protected ResourceOperation toResourceOperation(MatchingRule rule) {
        switch (rule) {
            case UPDATE: {
                return ResourceOperation.UPDATE;
            }
            case DEPROVISION: 
            case UNASSIGN: {
                return ResourceOperation.DELETE;
            }
        }
        return ResourceOperation.NONE;
    }

    protected ProvisioningReport.Status toProvisioningReportStatus(PropagationTaskExecStatus status) {
        switch (status) {
            case FAILURE: {
                return ProvisioningReport.Status.FAILURE;
            }
            case SUCCESS: {
                return ProvisioningReport.Status.SUCCESS;
            }
        }
        return ProvisioningReport.Status.IGNORE;
    }
}

