/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheValue;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractSyncopeResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.PullUtils;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public abstract class AbstractPullResultHandler
extends AbstractSyncopeResultHandler<PullTask, PullActions>
implements SyncopePullResultHandler {
    @Autowired
    protected PullUtils pullUtils;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected ConnObjectUtils connObjectUtils;
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected VirAttrCache virAttrCache;
    protected SyncopePullExecutor executor;
    protected AuditElements.Result latestResult;

    protected abstract String getName(AnyTO var1);

    protected abstract ProvisioningManager<?, ?> getProvisioningManager();

    protected abstract AnyTO doCreate(AnyTO var1, SyncDelta var2);

    protected abstract AnyPatch doUpdate(AnyTO var1, AnyPatch var2, SyncDelta var3, ProvisioningReport var4);

    protected void doDelete(AnyTypeKind kind, String key) {
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.DELETE, ((PullTask)this.profile.getTask()).getResource().getKey());
        try {
            this.taskExecutor.execute((Collection)this.propagationManager.getDeleteTasks(kind, key, propByRes, null), false);
        }
        catch (Exception e) {
            LOG.error("Could not propagate anyObject " + key, (Throwable)e);
        }
        this.getProvisioningManager().delete(key, Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
    }

    public void setPullExecutor(SyncopePullExecutor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(SyncDelta delta) {
        Provision provision = null;
        try {
            boolean shouldContinue;
            provision = ((PullTask)this.profile.getTask()).getResource().getProvision(delta.getObject().getObjectClass());
            if (provision == null) {
                throw new JobExecutionException("No provision found on " + ((PullTask)this.profile.getTask()).getResource() + " for " + delta.getObject().getObjectClass());
            }
            this.doHandle(delta, provision);
            this.executor.reportHandled(delta.getObjectClass(), delta.getObject().getName());
            LOG.debug("Successfully handled {}", (Object)delta);
            if (((PullTask)this.profile.getTask()).getPullMode() != PullMode.INCREMENTAL) {
                if (this.executor.wasInterruptRequested()) {
                    LOG.debug("Pull interrupted");
                    this.executor.setInterrupted();
                    return false;
                }
                return true;
            }
            AbstractPullResultHandler abstractPullResultHandler = this;
            synchronized (abstractPullResultHandler) {
                shouldContinue = this.latestResult == AuditElements.Result.SUCCESS;
                this.latestResult = null;
            }
            if (shouldContinue) {
                this.executor.setLatestSyncToken(delta.getObjectClass(), delta.getToken());
            }
            if (this.executor.wasInterruptRequested()) {
                LOG.debug("Pull interrupted");
                this.executor.setInterrupted();
                return false;
            }
            return shouldContinue;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport ignoreResult = new ProvisioningReport();
            ignoreResult.setOperation(ResourceOperation.NONE);
            ignoreResult.setAnyType(provision == null ? this.getAnyUtils().getAnyTypeKind().name() : provision.getAnyType().getKey());
            ignoreResult.setStatus(ProvisioningReport.Status.IGNORE);
            ignoreResult.setKey(null);
            ignoreResult.setName(delta.getObject().getName().getNameValue());
            this.profile.getResults().add(ignoreResult);
            LOG.warn("Ignoring during pull", (Throwable)e);
            this.executor.setLatestSyncToken(delta.getObjectClass(), delta.getToken());
            this.executor.reportHandled(delta.getObjectClass(), delta.getObject().getName());
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Pull failed", (Throwable)e);
            return false;
        }
    }

    protected List<ProvisioningReport> assign(SyncDelta delta, Provision provision, AnyUtils anyUtils) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("PullTask not configured for create");
            this.finalize(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.ASSIGN), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Collections.emptyList();
        }
        Object anyTO = this.connObjectUtils.getAnyTO(delta.getObject(), (PullTask)this.profile.getTask(), provision, anyUtils);
        anyTO.getResources().add(((PullTask)this.profile.getTask()).getResource().getKey());
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType(provision.getAnyType().getKey());
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(this.getName((AnyTO)anyTO));
        if (this.profile.isDryRun()) {
            result.setKey(null);
            this.finalize(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.ASSIGN), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
        } else {
            for (PullActions action : this.profile.getActions()) {
                action.beforeAssign(this.profile, delta, anyTO);
            }
            this.create((AnyTO)anyTO, delta, UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.ASSIGN), result);
        }
        return Collections.singletonList(result);
    }

    protected List<ProvisioningReport> provision(SyncDelta delta, Provision provision, AnyUtils anyUtils) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("PullTask not configured for create");
            this.finalize(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.PROVISION), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Collections.emptyList();
        }
        Object anyTO = this.connObjectUtils.getAnyTO(delta.getObject(), (PullTask)this.profile.getTask(), provision, anyUtils);
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType(provision.getAnyType().getKey());
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(this.getName((AnyTO)anyTO));
        if (this.profile.isDryRun()) {
            result.setKey(null);
            this.finalize(UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.PROVISION), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
        } else {
            for (PullActions action : this.profile.getActions()) {
                action.beforeProvision(this.profile, delta, anyTO);
            }
            this.create((AnyTO)anyTO, delta, UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.PROVISION), result);
        }
        return Collections.singletonList(result);
    }

    protected void throwIgnoreProvisionException(SyncDelta delta, Exception exception) throws JobExecutionException {
        if (exception instanceof IgnoreProvisionException) {
            throw (IgnoreProvisionException)((Object)IgnoreProvisionException.class.cast(exception));
        }
        IgnoreProvisionException ipe = null;
        for (PullActions action : this.profile.getActions()) {
            if (ipe != null) continue;
            ipe = action.onError(this.profile, delta, exception);
        }
        if (ipe != null) {
            throw ipe;
        }
    }

    protected void create(AnyTO anyTO, SyncDelta delta, String operation, ProvisioningReport result) throws JobExecutionException {
        AuditElements.Result resultStatus;
        Object output;
        try {
            AnyTO created;
            output = created = this.doCreate(anyTO, delta);
            result.setKey(created.getKey());
            result.setName(this.getName(created));
            resultStatus = AuditElements.Result.SUCCESS;
            for (PullActions action : this.profile.getActions()) {
                action.after(this.profile, delta, (EntityTO)created, result);
            }
            LOG.debug("{} {} successfully created", (Object)created.getType(), (Object)created.getKey());
        }
        catch (PropagationException e) {
            LOG.error("Could not propagate {} {}", new Object[]{anyTO.getType(), delta.getUid().getUidValue(), e});
            output = e;
            resultStatus = AuditElements.Result.FAILURE;
        }
        catch (Exception e) {
            this.throwIgnoreProvisionException(delta, e);
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOG.error("Could not create {} {} ", new Object[]{anyTO.getType(), delta.getUid().getUidValue(), e});
            output = e;
            resultStatus = AuditElements.Result.FAILURE;
        }
        this.finalize(operation, resultStatus, null, output, delta, new Object[0]);
    }

    protected List<ProvisioningReport> update(SyncDelta delta, List<String> anyKeys, Provision provision) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.finalize(MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Collections.emptyList();
        }
        LOG.debug("About to update {}", anyKeys);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (String key : anyKeys) {
            LOG.debug("About to update {}", (Object)key);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.UPDATE);
            result.setAnyType(provision.getAnyType().getKey());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(key);
            AnyTO before = this.getAnyTO(key);
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Any '%s(%s)' not found", provision.getAnyType().getKey(), key));
            } else {
                result.setName(this.getName(before));
            }
            if (!this.profile.isDryRun()) {
                Throwable output;
                AuditElements.Result resultStatus;
                AnyPatch effectivePatch = null;
                if (before == null) {
                    resultStatus = AuditElements.Result.FAILURE;
                    output = null;
                } else {
                    try {
                        Object anyPatch = this.connObjectUtils.getAnyPatch(before.getKey(), delta.getObject(), before, (PullTask)this.profile.getTask(), provision, this.getAnyUtils());
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeUpdate(this.profile, delta, (EntityTO)before, anyPatch);
                        }
                        effectivePatch = this.doUpdate(before, (AnyPatch)anyPatch, delta, result);
                        AnyTO updated = AnyOperations.patch((AnyTO)before, (AnyPatch)effectivePatch);
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)updated, result);
                        }
                        output = updated;
                        resultStatus = AuditElements.Result.SUCCESS;
                        result.setName(this.getName(updated));
                        LOG.debug("{} {} successfully updated", (Object)provision.getAnyType().getKey(), (Object)key);
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                }
                this.finalize(MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), resultStatus, before, output, delta, effectivePatch);
            }
            results.add(result);
        }
        return results;
    }

    protected List<ProvisioningReport> deprovision(SyncDelta delta, List<String> anyKeys, Provision provision, boolean unlink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.finalize(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNASSIGN) : MatchingRule.toEventName((MatchingRule)MatchingRule.DEPROVISION), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Collections.emptyList();
        }
        LOG.debug("About to deprovision {}", anyKeys);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (String key : anyKeys) {
            LOG.debug("About to unassign resource {}", (Object)key);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.DELETE);
            result.setAnyType(provision.getAnyType().getKey());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(key);
            AnyTO before = this.getAnyTO(key);
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Any '%s(%s)' not found", provision.getAnyType().getKey(), key));
            }
            if (!this.profile.isDryRun()) {
                Throwable output;
                AuditElements.Result resultStatus;
                if (before == null) {
                    resultStatus = AuditElements.Result.FAILURE;
                    output = null;
                } else {
                    result.setName(this.getName(before));
                    try {
                        if (unlink) {
                            for (PullActions action : this.profile.getActions()) {
                                action.beforeUnassign(this.profile, delta, (EntityTO)before);
                            }
                        } else {
                            for (PullActions action : this.profile.getActions()) {
                                action.beforeDeprovision(this.profile, delta, (EntityTO)before);
                            }
                        }
                        PropagationByResource propByRes = new PropagationByResource();
                        propByRes.add(ResourceOperation.DELETE, ((PullTask)this.profile.getTask()).getResource().getKey());
                        this.taskExecutor.execute((Collection)this.propagationManager.getDeleteTasks(provision.getAnyType().getKind(), key, propByRes, null), false);
                        AnyPatch anyPatch = null;
                        if (unlink) {
                            anyPatch = this.newPatch(key);
                            anyPatch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value((Object)((PullTask)this.profile.getTask()).getResource().getKey())).build());
                        }
                        output = anyPatch == null ? this.getAnyTO(key) : this.doUpdate(before, anyPatch, delta, result);
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)AnyTO.class.cast(output), result);
                        }
                        resultStatus = AuditElements.Result.SUCCESS;
                        LOG.debug("{} {} successfully updated", (Object)provision.getAnyType().getKey(), (Object)key);
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                }
                this.finalize(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNASSIGN) : MatchingRule.toEventName((MatchingRule)MatchingRule.DEPROVISION), resultStatus, before, output, delta, new Object[0]);
            }
            results.add(result);
        }
        return results;
    }

    protected List<ProvisioningReport> link(SyncDelta delta, List<String> anyKeys, Provision provision, boolean unlink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.finalize(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toEventName((MatchingRule)MatchingRule.LINK), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Collections.emptyList();
        }
        LOG.debug("About to update {}", anyKeys);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (String key : anyKeys) {
            LOG.debug("About to unassign resource {}", (Object)key);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.NONE);
            result.setAnyType(provision.getAnyType().getKey());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(key);
            AnyTO before = this.getAnyTO(key);
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Any '%s(%s)' not found", provision.getAnyType().getKey(), key));
            }
            if (!this.profile.isDryRun()) {
                Throwable output;
                AuditElements.Result resultStatus;
                AnyPatch effectivePatch = null;
                if (before == null) {
                    resultStatus = AuditElements.Result.FAILURE;
                    output = null;
                } else {
                    result.setName(this.getName(before));
                    try {
                        if (unlink) {
                            for (PullActions action : this.profile.getActions()) {
                                action.beforeUnlink(this.profile, delta, (EntityTO)before);
                            }
                        } else {
                            for (PullActions action : this.profile.getActions()) {
                                action.beforeLink(this.profile, delta, (EntityTO)before);
                            }
                        }
                        AnyPatch anyPatch = this.newPatch(before.getKey());
                        anyPatch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(unlink ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE)).value((Object)((PullTask)this.profile.getTask()).getResource().getKey())).build());
                        effectivePatch = (AnyPatch)this.update(anyPatch).getResult();
                        output = AnyOperations.patch((AnyTO)before, (AnyPatch)effectivePatch);
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)AnyTO.class.cast(output), result);
                        }
                        resultStatus = AuditElements.Result.SUCCESS;
                        LOG.debug("{} {} successfully updated", (Object)provision.getAnyType().getKey(), (Object)key);
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                }
                this.finalize(unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toEventName((MatchingRule)MatchingRule.LINK), resultStatus, before, output, delta, effectivePatch);
            }
            results.add(result);
        }
        return results;
    }

    protected List<ProvisioningReport> delete(SyncDelta delta, List<String> anyKeys, Provision provision) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformDelete()) {
            LOG.debug("PullTask not configured for delete");
            this.finalize(ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Collections.emptyList();
        }
        LOG.debug("About to delete {}", anyKeys);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (String key : anyKeys) {
            AuditElements.Result resultStatus = AuditElements.Result.FAILURE;
            ProvisioningReport result = new ProvisioningReport();
            try {
                AnyTO before = this.getAnyTO(key);
                result.setKey(key);
                result.setName(this.getName(before));
                result.setOperation(ResourceOperation.DELETE);
                result.setAnyType(provision.getAnyType().getKey());
                result.setStatus(ProvisioningReport.Status.SUCCESS);
                if (!this.profile.isDryRun()) {
                    Exception output;
                    for (PullActions action : this.profile.getActions()) {
                        action.beforeDelete(this.profile, delta, (EntityTO)before);
                    }
                    try {
                        this.doDelete(provision.getAnyType().getKind(), key);
                        output = null;
                        resultStatus = AuditElements.Result.SUCCESS;
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)before, result);
                        }
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not delete {} {}", new Object[]{provision.getAnyType().getKey(), key, e});
                        output = e;
                    }
                    this.finalize(ResourceOperation.DELETE.name().toLowerCase(), resultStatus, before, output, delta, new Object[0]);
                }
                results.add(result);
            }
            catch (NotFoundException e) {
                LOG.error("Could not find {} {}", new Object[]{provision.getAnyType().getKey(), key, e});
            }
            catch (DelegatedAdministrationException e) {
                LOG.error("Not allowed to read {} {}", new Object[]{provision.getAnyType().getKey(), key, e});
            }
            catch (Exception e) {
                LOG.error("Could not delete {} {}", new Object[]{provision.getAnyType().getKey(), key, e});
            }
        }
        return results;
    }

    protected List<ProvisioningReport> ignore(SyncDelta delta, List<String> anyKeys, Provision provision, boolean matching, String ... message) throws JobExecutionException {
        LOG.debug("Any to ignore {}", (Object)delta.getObject().getUid().getUidValue());
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        if (anyKeys == null) {
            ProvisioningReport report = new ProvisioningReport();
            report.setKey(null);
            report.setName(delta.getObject().getUid().getUidValue());
            report.setOperation(ResourceOperation.NONE);
            report.setAnyType(provision.getAnyType().getKey());
            report.setStatus(ProvisioningReport.Status.SUCCESS);
            if (message != null && message.length >= 1) {
                report.setMessage(message[0]);
            }
            results.add(report);
        } else {
            for (String anyKey : anyKeys) {
                ProvisioningReport report = new ProvisioningReport();
                report.setKey(anyKey);
                report.setName(delta.getObject().getUid().getUidValue());
                report.setOperation(ResourceOperation.NONE);
                report.setAnyType(provision.getAnyType().getKey());
                report.setStatus(ProvisioningReport.Status.SUCCESS);
                if (message != null && message.length >= 1) {
                    report.setMessage(message[0]);
                }
                results.add(report);
            }
        }
        this.finalize(matching ? MatchingRule.toEventName((MatchingRule)MatchingRule.IGNORE) : UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.IGNORE), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
        return results;
    }

    protected void doHandle(SyncDelta delta, Provision provision) throws JobExecutionException {
        AnyUtils anyUtils = this.getAnyUtils();
        LOG.debug("Process {} for {} as {}", new Object[]{delta.getDeltaType(), delta.getUid().getUidValue(), delta.getObject().getObjectClass()});
        SyncDelta processed = delta;
        for (PullActions action : this.profile.getActions()) {
            processed = action.preprocess(this.profile, processed);
        }
        LOG.debug("Transformed {} for {} as {}", new Object[]{processed.getDeltaType(), processed.getUid().getUidValue(), processed.getObject().getObjectClass()});
        String uid = processed.getPreviousUid() == null ? processed.getUid().getUidValue() : processed.getPreviousUid().getUidValue();
        try {
            List<String> anyKeys = this.pullUtils.findExisting(uid, processed.getObject(), provision, anyUtils);
            LOG.debug("Match(es) found for {} as {}: {}", new Object[]{processed.getUid().getUidValue(), processed.getObject().getObjectClass(), anyKeys});
            if (anyKeys.size() > 1) {
                switch (this.profile.getResAct()) {
                    case IGNORE: {
                        throw new IllegalStateException("More than one match " + anyKeys);
                    }
                    case FIRSTMATCH: {
                        anyKeys = anyKeys.subList(0, 1);
                        break;
                    }
                    case LASTMATCH: {
                        anyKeys = anyKeys.subList(anyKeys.size() - 1, anyKeys.size());
                        break;
                    }
                }
            }
            if (SyncDeltaType.CREATE_OR_UPDATE == processed.getDeltaType()) {
                if (anyKeys.isEmpty()) {
                    switch (((PullTask)this.profile.getTask()).getUnmatchingRule()) {
                        case ASSIGN: {
                            this.profile.getResults().addAll(this.assign(processed, provision, anyUtils));
                            break;
                        }
                        case PROVISION: {
                            this.profile.getResults().addAll(this.provision(processed, provision, anyUtils));
                            break;
                        }
                        case IGNORE: {
                            this.profile.getResults().addAll(this.ignore(processed, null, provision, false, new String[0]));
                            break;
                        }
                    }
                } else {
                    for (VirSchema virSchema : this.virSchemaDAO.findByProvision(provision)) {
                        Attribute attr = processed.getObject().getAttributeByName(virSchema.getExtAttrName());
                        for (String anyKey : anyKeys) {
                            if (attr == null) {
                                this.virAttrCache.expire(provision.getAnyType().getKey(), anyKey, virSchema.getKey());
                                continue;
                            }
                            VirAttrCacheValue cacheValue = new VirAttrCacheValue();
                            cacheValue.setValues((Collection)attr.getValue());
                            this.virAttrCache.put(provision.getAnyType().getKey(), anyKey, virSchema.getKey(), cacheValue);
                        }
                    }
                    switch (((PullTask)this.profile.getTask()).getMatchingRule()) {
                        case UPDATE: {
                            this.profile.getResults().addAll(this.update(processed, anyKeys, provision));
                            break;
                        }
                        case DEPROVISION: {
                            this.profile.getResults().addAll(this.deprovision(processed, anyKeys, provision, false));
                            break;
                        }
                        case UNASSIGN: {
                            this.profile.getResults().addAll(this.deprovision(processed, anyKeys, provision, true));
                            break;
                        }
                        case LINK: {
                            this.profile.getResults().addAll(this.link(processed, anyKeys, provision, false));
                            break;
                        }
                        case UNLINK: {
                            this.profile.getResults().addAll(this.link(processed, anyKeys, provision, true));
                            break;
                        }
                        case IGNORE: {
                            this.profile.getResults().addAll(this.ignore(processed, anyKeys, provision, true, new String[0]));
                            break;
                        }
                    }
                }
            } else if (SyncDeltaType.DELETE == processed.getDeltaType()) {
                if (anyKeys.isEmpty()) {
                    this.finalize(ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, processed, new Object[0]);
                    LOG.debug("No match found for deletion");
                } else {
                    this.profile.getResults().addAll(this.delete(processed, anyKeys, provision));
                }
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LOG.warn(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize(String event, AuditElements.Result result, Object before, Object output, SyncDelta delta, Object ... furtherInput) {
        AbstractPullResultHandler abstractPullResultHandler = this;
        synchronized (abstractPullResultHandler) {
            this.latestResult = result;
        }
        this.notificationManager.createTasks(AuditElements.EventCategoryType.PULL, this.getAnyUtils().getAnyTypeKind().name().toLowerCase(), ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta, furtherInput});
        this.auditManager.audit(AuditElements.EventCategoryType.PULL, this.getAnyUtils().getAnyTypeKind().name().toLowerCase(), ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta, furtherInput});
    }
}

