/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.types.PropagationTaskExecStatus;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskCallable;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.propagation.AbstractPropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationTaskCallable;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class PriorityPropagationTaskExecutor
extends AbstractPropagationTaskExecutor {
    @Resource(name="propagationTaskExecutorAsyncExecutor")
    protected ThreadPoolTaskExecutor executor;

    protected PropagationTaskCallable newPropagationTaskCallable(PropagationTaskTO taskTO, PropagationReporter reporter) {
        PropagationTaskCallable callable = (PropagationTaskCallable)ApplicationContextProvider.getBeanFactory().createBean(DefaultPropagationTaskCallable.class, 2, false);
        callable.setExecutor((PropagationTaskExecutor)this);
        callable.setTaskTO(taskTO);
        callable.setReporter(reporter);
        return callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void doExecute(Collection<PropagationTaskTO> tasks, PropagationReporter reporter, boolean nullPriorityAsync) {
        block16: {
            final HashMap<PropagationTaskTO, ExternalResource> taskToResource = new HashMap<PropagationTaskTO, ExternalResource>(tasks.size());
            for (PropagationTaskTO task : tasks) {
                taskToResource.put(task, this.resourceDAO.find(task.getResource()));
            }
            List prioritizedTasks = (List)CollectionUtils.select(tasks, (Predicate)new Predicate<PropagationTaskTO>(){

                public boolean evaluate(PropagationTaskTO task) {
                    return ((ExternalResource)taskToResource.get(task)).getPropagationPriority() != null;
                }
            }, new ArrayList());
            Collections.sort(prioritizedTasks, new PriorityComparator(taskToResource));
            LOG.debug("Propagation tasks sorted by priority, for serial execution: {}", (Object)prioritizedTasks);
            Collection concurrentTasks = CollectionUtils.subtract(tasks, (Iterable)prioritizedTasks);
            LOG.debug("Propagation tasks for concurrent execution: {}", (Object)concurrentTasks);
            for (PropagationTaskTO task : prioritizedTasks) {
                void var10_10;
                Object execution = null;
                try {
                    execution = (TaskExec)this.newPropagationTaskCallable(task, reporter).call();
                    PropagationTaskExecStatus propagationTaskExecStatus = PropagationTaskExecStatus.valueOf((String)execution.getStatus());
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception", (Throwable)e);
                    PropagationTaskExecStatus propagationTaskExecStatus = PropagationTaskExecStatus.FAILURE;
                }
                if (var10_10 == PropagationTaskExecStatus.SUCCESS) continue;
                throw new PropagationException(task.getResource(), execution == null ? null : execution.getMessage());
            }
            final ExecutorCompletionService completionService = new ExecutorCompletionService((Executor)this.executor);
            HashMap nullPriority = new HashMap(concurrentTasks.size());
            for (PropagationTaskTO propagationTaskTO : concurrentTasks) {
                try {
                    nullPriority.put(propagationTaskTO, completionService.submit(this.newPropagationTaskCallable(propagationTaskTO, reporter)));
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception", (Throwable)e);
                }
            }
            if (nullPriority.isEmpty()) break block16;
            if (nullPriorityAsync) {
                for (Map.Entry entry : nullPriority.entrySet()) {
                    reporter.onSuccessOrNonPriorityResourceFailures((PropagationTaskTO)entry.getKey(), PropagationTaskExecStatus.CREATED, null, null, null);
                }
            } else {
                final HashSet nullPriorityFutures = new HashSet(nullPriority.values());
                try {
                    this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            while (!nullPriorityFutures.isEmpty()) {
                                try {
                                    nullPriorityFutures.remove(completionService.take());
                                }
                                catch (Exception e) {
                                    AbstractPropagationTaskExecutor.LOG.error("Unexpected exception", (Throwable)e);
                                }
                            }
                        }
                    }).get(60L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    LOG.error("Unexpected exception", (Throwable)exception);
                }
                finally {
                    for (Future future : nullPriorityFutures) {
                        future.cancel(true);
                    }
                    nullPriorityFutures.clear();
                    nullPriority.clear();
                }
            }
        }
    }

    protected static class PriorityComparator
    implements Comparator<PropagationTaskTO>,
    Serializable {
        private static final long serialVersionUID = -1969355670784448878L;
        private final Map<PropagationTaskTO, ExternalResource> taskToResource;

        public PriorityComparator(Map<PropagationTaskTO, ExternalResource> taskToResource) {
            this.taskToResource = taskToResource;
        }

        @Override
        public int compare(PropagationTaskTO task1, PropagationTaskTO task2) {
            int prop2;
            int prop1 = this.taskToResource.get(task1).getPropagationPriority();
            return prop1 > (prop2 = this.taskToResource.get(task2).getPropagationPriority().intValue()) ? 1 : (prop1 == prop2 ? 0 : -1);
        }
    }
}

