/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.HashSet;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.dao.PlainAttrValueDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationActions;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class GoogleAppsPropagationActions
extends DefaultPropagationActions {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleAppsPropagationActions.class);
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    protected PlainAttrValueDAO plainAttrValueDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    protected String getEmailSchema() {
        return "email";
    }

    protected String getGoogleAppsIdSchema() {
        return "GoogleAppsId";
    }

    @Override
    @Transactional
    public void before(PropagationTask task, ConnectorObject beforeObj) {
        if (task.getOperation() == ResourceOperation.DELETE || task.getOperation() == ResourceOperation.NONE) {
            return;
        }
        if (AnyTypeKind.USER != task.getAnyTypeKind()) {
            return;
        }
        HashSet<Name> attrs = new HashSet<Name>(task.getAttributes());
        User user = (User)this.userDAO.find(task.getEntityKey());
        if (user == null) {
            LOG.error("Could not find user {}, skipping", (Object)task.getEntityKey());
        } else {
            Name name = AttributeUtil.getNameFromAttributes(attrs);
            if (name != null) {
                attrs.remove(name);
            }
            attrs.add(new Name((String)((UPlainAttr)user.getPlainAttr(this.getEmailSchema())).getValuesAsStrings().get(0)));
        }
        task.setAttributes(attrs);
    }

    @Override
    @Transactional
    public void after(PropagationTask task, TaskExec execution, ConnectorObject afterObj) {
        if (task.getOperation() == ResourceOperation.DELETE || task.getOperation() == ResourceOperation.NONE) {
            return;
        }
        if (AnyTypeKind.USER != task.getAnyTypeKind()) {
            return;
        }
        User user = (User)this.userDAO.find(task.getEntityKey());
        if (user == null) {
            LOG.error("Could not find user {}, skipping", (Object)task.getEntityKey());
        } else {
            boolean modified = false;
            AnyUtils anyUtils = this.anyUtilsFactory.getInstance((Any)user);
            PlainSchema googleAppsId = (PlainSchema)this.plainSchemaDAO.find(this.getGoogleAppsIdSchema());
            if (googleAppsId == null) {
                LOG.error("Could not find schema {}, skipping", (Object)this.getGoogleAppsIdSchema());
            } else {
                UPlainAttr attr = (UPlainAttr)user.getPlainAttr(this.getGoogleAppsIdSchema());
                if (attr == null) {
                    attr = (UPlainAttr)this.entityFactory.newEntity(UPlainAttr.class);
                    attr.setSchema(googleAppsId);
                    attr.setOwner((Any)user);
                    user.add((GroupablePlainAttr)attr);
                    try {
                        attr.add(afterObj.getUid().getUidValue(), anyUtils);
                        modified = true;
                    }
                    catch (InvalidPlainAttrValueException e) {
                        LOG.error("Invalid value for attribute {}: {}", new Object[]{googleAppsId.getKey(), afterObj.getUid().getUidValue(), e});
                    }
                } else {
                    LOG.debug("User {} has already {} assigned: {}", new Object[]{user, googleAppsId.getKey(), attr.getValuesAsStrings()});
                }
            }
            if (modified) {
                this.userDAO.save((Any)user);
            }
        }
    }
}

