/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.types.PropagationTaskExecStatus;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropagationReporter
implements PropagationReporter {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultPropagationReporter.class);
    protected final List<PropagationStatus> statuses = new ArrayList<PropagationStatus>();

    protected boolean add(final PropagationStatus status) {
        return IterableUtils.matchesAny(this.statuses, (Predicate)new Predicate<PropagationStatus>(){

            public boolean evaluate(PropagationStatus item) {
                return item.getResource().equals(status.getResource());
            }
        }) ? false : this.statuses.add(status);
    }

    public void onSuccessOrNonPriorityResourceFailures(PropagationTaskTO taskTO, PropagationTaskExecStatus executionStatus, String failureReason, ConnectorObject beforeObj, ConnectorObject afterObj) {
        PropagationStatus status = new PropagationStatus();
        status.setResource(taskTO.getResource());
        status.setStatus(executionStatus);
        status.setFailureReason(failureReason);
        if (beforeObj != null) {
            status.setBeforeObj(ConnObjectUtils.getConnObjectTO(beforeObj));
        }
        if (afterObj != null) {
            status.setAfterObj(ConnObjectUtils.getConnObjectTO(afterObj));
        }
        this.add(status);
    }

    public void onPriorityResourceFailure(final String failingResource, Collection<PropagationTaskTO> tasks) {
        LOG.debug("Propagation error: {} priority resource failed to propagate", (Object)failingResource);
        PropagationTaskTO taskTO = (PropagationTaskTO)IterableUtils.find(tasks, (Predicate)new Predicate<PropagationTaskTO>(){

            public boolean evaluate(PropagationTaskTO taskTO) {
                return taskTO.getResource().equals(failingResource);
            }
        });
        if (taskTO == null) {
            LOG.error("Could not find {} for {}", (Object)PropagationTask.class.getName(), (Object)failingResource);
        } else {
            PropagationStatus status = new PropagationStatus();
            status.setResource(taskTO.getResource());
            status.setStatus(PropagationTaskExecStatus.FAILURE);
            status.setFailureReason("Propagation error: " + failingResource + " priority resource failed to propagate.");
            this.add(status);
        }
    }

    public List<PropagationStatus> getStatuses() {
        return Collections.unmodifiableList(this.statuses);
    }
}

