/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import org.apache.syncope.core.provisioning.api.job.JobDelegate;
import org.apache.syncope.core.provisioning.api.job.report.ReportJobDelegate;
import org.apache.syncope.core.provisioning.java.job.AbstractInterruptableJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ReportJob
extends AbstractInterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(ReportJob.class);
    private String reportKey;
    @Autowired
    private ReportJobDelegate delegate;

    public void setReportKey(String reportKey) {
        this.reportKey = reportKey;
    }

    @Override
    public JobDelegate getDelegate() {
        return this.delegate;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            AuthContextUtils.execWithAuthContext((String)context.getMergedJobDataMap().getString("domain"), (AuthContextUtils.Executable)new AuthContextUtils.Executable<Void>(){

                public Void exec() {
                    try {
                        ReportJob.this.delegate.execute(ReportJob.this.reportKey);
                    }
                    catch (Exception e) {
                        LOG.error("While executing report {}", (Object)ReportJob.this.reportKey, (Object)e);
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            LOG.error("While executing report {}", (Object)this.reportKey, (Object)e);
            throw new JobExecutionException("While executing report " + this.reportKey, (Throwable)e);
        }
    }
}

