/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.types.ReportExecStatus;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.dao.Reportlet;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.provisioning.api.job.report.ReportJobDelegate;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.java.job.report.ReportException;
import org.apache.syncope.core.provisioning.java.utils.VoidURIResolver;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

@Component
public class DefaultReportJobDelegate
implements ReportJobDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(ReportJobDelegate.class);
    private static final SAXTransformerFactory TRANSFORMER_FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();
    @Autowired
    private ReportDAO reportDAO;
    @Autowired
    private ReportExecDAO reportExecDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private ImplementationLookup implementationLookup;
    private final AtomicReference<String> status = new AtomicReference();
    private boolean interrupt;
    private boolean interrupted;

    public String currentStatus() {
        return this.status.get();
    }

    public void interrupt() {
        this.interrupt = true;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Transactional
    public void execute(String reportKey) throws JobExecutionException {
        TransformerHandler handler;
        Report report = this.reportDAO.find(reportKey);
        if (report == null) {
            throw new JobExecutionException("Report " + reportKey + " not found");
        }
        if (!report.isActive()) {
            LOG.info("Report {} not active, aborting...", (Object)reportKey);
            return;
        }
        ReportExec execution = (ReportExec)this.entityFactory.newEntity(ReportExec.class);
        execution.setStatus(ReportExecStatus.STARTED);
        execution.setStart(new Date());
        execution.setReport(report);
        execution = this.reportExecDAO.save(execution);
        report.add(execution);
        report = this.reportDAO.save(report);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        zos.setLevel(9);
        try {
            handler = TRANSFORMER_FACTORY.newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            serializer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            serializer.setOutputProperty("indent", "yes");
            zos.putNextEntry(new ZipEntry(report.getName()));
            handler.setResult(new StreamResult(zos));
        }
        catch (Exception e) {
            throw new JobExecutionException("While configuring for SAX generation", (Throwable)e, true);
        }
        execution.setStatus(ReportExecStatus.RUNNING);
        execution = this.reportExecDAO.save(execution);
        this.status.set("Starting");
        StringBuilder reportExecutionMessage = new StringBuilder();
        try {
            handler.startDocument();
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "name", "xsd:string", report.getName());
            handler.startElement("", "", "report", atts);
            this.status.set("Generating report header");
            List reportletConfs = report.getReportletConfs();
            for (int i = 0; i < reportletConfs.size() && !this.interrupt; ++i) {
                Reportlet reportlet;
                Class reportletClass = this.implementationLookup.getReportletClass(((ReportletConf)reportletConfs.get(i)).getClass());
                if (reportletClass == null) {
                    LOG.warn("Could not find matching reportlet for {}", ((ReportletConf)reportletConfs.get(i)).getClass());
                    continue;
                }
                if (ApplicationContextProvider.getBeanFactory().containsSingleton(reportletClass.getName())) {
                    reportlet = (Reportlet)ApplicationContextProvider.getBeanFactory().getSingleton(reportletClass.getName());
                } else {
                    reportlet = (Reportlet)ApplicationContextProvider.getBeanFactory().createBean(reportletClass, 2, false);
                    ApplicationContextProvider.getBeanFactory().registerSingleton(reportletClass.getName(), (Object)reportlet);
                }
                try {
                    this.status.set("Invoking reportlet " + reportletClass.getName());
                    reportlet.extract((ReportletConf)reportletConfs.get(i), (ContentHandler)handler, this.status);
                    continue;
                }
                catch (Throwable t) {
                    LOG.error("While executing reportlet {} for report {}", new Object[]{reportlet, reportKey, t});
                    execution.setStatus(ReportExecStatus.FAILURE);
                    Throwable effective = t instanceof ReportException ? t.getCause() : t;
                    reportExecutionMessage.append(ExceptionUtils2.getFullStackTrace((Throwable)effective)).append("\n==================\n");
                }
            }
            if (this.interrupt) {
                LOG.debug("Report job {} interrupted", (Object)reportKey);
                this.interrupted = true;
            }
            this.status.set("Generating report footer");
            handler.endElement("", "", "report");
            handler.endDocument();
            if (!ReportExecStatus.FAILURE.name().equals(execution.getStatus())) {
                execution.setStatus(ReportExecStatus.SUCCESS);
            }
        }
        catch (Exception e) {
            execution.setStatus(ReportExecStatus.FAILURE);
            reportExecutionMessage.append(ExceptionUtils2.getFullStackTrace((Throwable)e));
            throw new JobExecutionException((Throwable)e, true);
        }
        finally {
            this.status.set("Completed");
            try {
                zos.closeEntry();
                zos.close();
                baos.close();
            }
            catch (IOException e) {
                LOG.error("While closing StreamResult's backend", (Throwable)e);
            }
            execution.setExecResult(baos.toByteArray());
            execution.setMessage(reportExecutionMessage.toString());
            execution.setEnd(new Date());
            this.reportExecDAO.save(execution);
        }
    }

    static {
        TRANSFORMER_FACTORY.setURIResolver(new VoidURIResolver());
        try {
            TRANSFORMER_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            LOG.error("Could not enable secure XML processing", (Throwable)e);
        }
    }
}

