/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.core.persistence.api.dao.Reportlet;
import org.apache.syncope.core.provisioning.java.job.report.ReportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractReportlet
implements Reportlet {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractReportlet.class);

    protected abstract void doExtract(ReportletConf var1, ContentHandler var2, AtomicReference<String> var3) throws SAXException;

    @Transactional(readOnly=true)
    public void extract(ReportletConf conf, ContentHandler handler, AtomicReference<String> status) throws SAXException {
        if (conf == null) {
            throw new ReportException(new IllegalArgumentException("No configuration provided"));
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "name", "xsd:string", conf.getName());
        atts.addAttribute("", "", "class", "xsd:string", this.getClass().getName());
        handler.startElement("", "", "reportlet", atts);
        this.doExtract(conf, handler, status);
        handler.endElement("", "", "reportlet");
    }
}

