/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.notification;

import org.apache.syncope.core.persistence.api.DomainsHolder;
import org.apache.syncope.core.provisioning.api.job.JobDelegate;
import org.apache.syncope.core.provisioning.api.notification.NotificationJobDelegate;
import org.apache.syncope.core.provisioning.java.job.AbstractInterruptableJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationJob
extends AbstractInterruptableJob {
    public static final String DEFAULT_CRON_EXP = "0 0/5 * * * ?";
    private static final Logger LOG = LoggerFactory.getLogger(NotificationJob.class);
    @Autowired
    private DomainsHolder domainsHolder;
    @Autowired
    private NotificationJobDelegate delegate;

    @Override
    public JobDelegate getDelegate() {
        return this.delegate;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOG.debug("Waking up...");
        for (String domain : this.domainsHolder.getDomains().keySet()) {
            try {
                AuthContextUtils.execWithAuthContext((String)domain, (AuthContextUtils.Executable)new AuthContextUtils.Executable<Void>(){

                    public Void exec() {
                        try {
                            NotificationJob.this.delegate.execute();
                        }
                        catch (Exception e) {
                            LOG.error("While sending out notifications", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }
            catch (RuntimeException e) {
                LOG.error("While sending out notifications", (Throwable)e);
                throw new JobExecutionException("While sending out notifications", (Throwable)e);
            }
        }
        LOG.debug("Sleeping again...");
    }

    public static enum Status {
        SENT,
        NOT_SENT;

    }
}

