/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.util.Map;
import java.util.Set;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.MembershipPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.java.job.AbstractInterruptableJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SetUMembershipsJob
extends AbstractInterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(SetUMembershipsJob.class);
    public static final String MEMBERSHIPS_KEY = "memberships";
    @Autowired
    private UserProvisioningManager userProvisioningManager;

    public void execute(final JobExecutionContext context) throws JobExecutionException {
        try {
            AuthContextUtils.execWithAuthContext((String)context.getMergedJobDataMap().getString("domain"), (AuthContextUtils.Executable)new AuthContextUtils.Executable<Void>(){

                public Void exec() {
                    Map memberships = (Map)context.getMergedJobDataMap().get((Object)SetUMembershipsJob.MEMBERSHIPS_KEY);
                    LOG.debug("About to set memberships (User -> Groups) {}", (Object)memberships);
                    for (Map.Entry membership : memberships.entrySet()) {
                        UserPatch userPatch = new UserPatch();
                        userPatch.setKey((String)membership.getKey());
                        for (String groupKey : (Set)membership.getValue()) {
                            userPatch.getMemberships().add(((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).group(groupKey).build());
                        }
                        if (userPatch.isEmpty()) continue;
                        LOG.debug("About to update User {}", (Object)userPatch.getKey());
                        SetUMembershipsJob.this.userProvisioningManager.update((AnyPatch)userPatch, true);
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            LOG.error("While setting memberships", (Throwable)e);
            throw new JobExecutionException("While executing memberships", (Throwable)e);
        }
    }
}

