/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.jexl;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.utils.FormatUtils;
import org.apache.syncope.core.provisioning.java.jexl.ClassFreeUberspect;
import org.apache.syncope.core.provisioning.java.jexl.EmptyClassLoader;
import org.apache.syncope.core.provisioning.java.jexl.SyncopeJexlFunctions;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JexlUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JexlUtils.class);
    private static final String[] IGNORE_FIELDS = new String[]{"password", "clearPassword", "serialVersionUID", "class"};
    private static final Map<Class<?>, Set<PropertyDescriptor>> FIELD_CACHE = Collections.synchronizedMap(new HashMap());
    private static JexlEngine JEXL_ENGINE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JexlEngine getEngine() {
        Logger logger = LOG;
        synchronized (logger) {
            if (JEXL_ENGINE == null) {
                JEXL_ENGINE = new JexlBuilder().uberspect((JexlUberspect)new ClassFreeUberspect()).loader((ClassLoader)new EmptyClassLoader()).namespaces(Collections.singletonMap("syncope", new SyncopeJexlFunctions())).cache(512).silent(false).strict(false).create();
            }
        }
        return JEXL_ENGINE;
    }

    public static JxltEngine newJxltEngine() {
        return JexlUtils.getEngine().createJxltEngine(false);
    }

    public static boolean isExpressionValid(String expression) {
        boolean result;
        try {
            JexlUtils.getEngine().createExpression(expression);
            result = true;
        }
        catch (JexlException e) {
            LOG.error("Invalid jexl expression: " + expression, (Throwable)e);
            result = false;
        }
        return result;
    }

    public static String evaluate(String expression, JexlContext jexlContext) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)expression) && jexlContext != null) {
            try {
                JexlExpression jexlExpression = JexlUtils.getEngine().createExpression(expression);
                Object evaluated = jexlExpression.evaluate(jexlContext);
                if (evaluated != null) {
                    result = evaluated.toString();
                }
            }
            catch (Exception e) {
                LOG.error("Error while evaluating JEXL expression: " + expression, (Throwable)e);
            }
        } else {
            LOG.debug("Expression not provided or invalid context");
        }
        return result;
    }

    public static void addFieldsToContext(Object object, JexlContext jexlContext) {
        Set<PropertyDescriptor> cached = FIELD_CACHE.get(object.getClass());
        if (cached == null) {
            cached = new HashSet<PropertyDescriptor>();
            FIELD_CACHE.put(object.getClass(), cached);
            try {
                for (PropertyDescriptor desc : Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors()) {
                    if (desc.getName().startsWith("pc") || ArrayUtils.contains((Object[])IGNORE_FIELDS, (Object)desc.getName()) || Iterable.class.isAssignableFrom(desc.getPropertyType()) || desc.getPropertyType().isArray()) continue;
                    cached.add(desc);
                }
            }
            catch (IntrospectionException ie) {
                LOG.error("Reading class attributes error", (Throwable)ie);
            }
        }
        for (PropertyDescriptor desc : cached) {
            String fieldName = desc.getName();
            Class<?> fieldType = desc.getPropertyType();
            try {
                Object fieldValue;
                if (desc.getReadMethod() == null) {
                    Field field = object.getClass().getDeclaredField(fieldName);
                    field.setAccessible(true);
                    fieldValue = field.get(object);
                } else {
                    fieldValue = desc.getReadMethod().invoke(object, new Object[0]);
                }
                fieldValue = fieldValue == null ? "" : (fieldType.equals(Date.class) ? FormatUtils.format((Date)((Date)fieldValue), (boolean)false) : fieldValue);
                jexlContext.set(fieldName, fieldValue);
                LOG.debug("Add field {} with value {}", (Object)fieldName, fieldValue);
            }
            catch (Exception iae) {
                LOG.error("Reading '{}' value error", (Object)fieldName, (Object)iae);
            }
        }
        if (object instanceof Any && ((Any)object).getRealm() != null) {
            jexlContext.set("realm", (Object)((Any)object).getRealm().getFullPath());
        } else if (object instanceof AnyTO && ((AnyTO)object).getRealm() != null) {
            jexlContext.set("realm", (Object)((AnyTO)object).getRealm());
        } else if (object instanceof Realm) {
            jexlContext.set("fullPath", (Object)((Realm)object).getFullPath());
        } else if (object instanceof RealmTO) {
            jexlContext.set("fullPath", (Object)((RealmTO)object).getFullPath());
        }
    }

    public static void addAttrTOsToContext(Collection<AttrTO> attrs, JexlContext jexlContext) {
        for (AttrTO attr : attrs) {
            if (attr.getSchema() == null) continue;
            String expressionValue = attr.getValues().isEmpty() ? "" : (String)attr.getValues().get(0);
            LOG.debug("Add attribute {} with value {}", (Object)attr.getSchema(), (Object)expressionValue);
            jexlContext.set(attr.getSchema(), (Object)expressionValue);
        }
    }

    public static void addPlainAttrsToContext(Collection<? extends PlainAttr<?>> attrs, JexlContext jexlContext) {
        for (PlainAttr<?> attr : attrs) {
            if (attr.getSchema() == null) continue;
            List attrValues = attr.getValuesAsStrings();
            String expressionValue = attrValues.isEmpty() ? "" : (String)attrValues.get(0);
            LOG.debug("Add attribute {} with value {}", (Object)attr.getSchema().getKey(), (Object)expressionValue);
            jexlContext.set(attr.getSchema().getKey(), (Object)expressionValue);
        }
    }

    public static void addDerAttrsToContext(Any<?> any, JexlContext jexlContext) {
        Map derAttrs = ((DerAttrHandler)ApplicationContextProvider.getBeanFactory().getBean(DerAttrHandler.class)).getValues(any);
        for (Map.Entry entry : derAttrs.entrySet()) {
            jexlContext.set(((DerSchema)entry.getKey()).getKey(), entry.getValue());
        }
    }

    public static boolean evaluateMandatoryCondition(String mandatoryCondition, Any<?> any) {
        MapContext jexlContext = new MapContext();
        JexlUtils.addPlainAttrsToContext(any.getPlainAttrs(), (JexlContext)jexlContext);
        JexlUtils.addDerAttrsToContext(any, (JexlContext)jexlContext);
        return Boolean.parseBoolean(JexlUtils.evaluate(mandatoryCondition, (JexlContext)jexlContext));
    }

    private JexlUtils() {
    }
}

