/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.patch.MembershipPatch;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.user.SecurityQuestion;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.utils.EntityUtils;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.apache.syncope.core.spring.BeanUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.Encryptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Throwable.class})
public class UserDataBinderImpl
extends AbstractAnyDataBinder
implements UserDataBinder {
    private static final String[] IGNORE_PROPERTIES = new String[]{"type", "realm", "auxClasses", "roles", "dynRoles", "relationships", "memberships", "dynMemberships", "plainAttrs", "derAttrs", "virAttrs", "resources", "securityQuestion", "securityAnswer"};
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private SecurityQuestionDAO securityQuestionDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private AccessTokenDAO accessTokenDAO;
    @Resource(name="adminUser")
    private String adminUser;
    @Resource(name="anonymousUser")
    private String anonymousUser;

    @Transactional(readOnly=true)
    public UserTO returnUserTO(UserTO userTO) {
        if (!((Boolean)this.confDAO.find("return.password.value", (Object)false)).booleanValue()) {
            userTO.setPassword(null);
        }
        return userTO;
    }

    @Transactional(readOnly=true)
    public UserTO getAuthenticatedUserTO() {
        UserTO authUserTO;
        String authUsername = AuthContextUtils.getUsername();
        if (this.anonymousUser.equals(authUsername)) {
            authUserTO = new UserTO();
            authUserTO.setKey(null);
            authUserTO.setUsername(this.anonymousUser);
        } else if (this.adminUser.equals(authUsername)) {
            authUserTO = new UserTO();
            authUserTO.setKey(null);
            authUserTO.setUsername(this.adminUser);
        } else {
            User authUser = this.userDAO.findByUsername(authUsername);
            authUserTO = this.getUserTO(authUser, true);
        }
        return authUserTO;
    }

    @Transactional(readOnly=true)
    public boolean verifyPassword(User user, String password) {
        return ENCRYPTOR.verify(password, user.getCipherAlgorithm(), user.getPassword());
    }

    private void setPassword(User user, String password, SyncopeClientCompositeException scce) {
        try {
            String algorithm = (String)this.confDAO.find("password.cipher.algorithm", (Object)CipherAlgorithm.AES.name());
            CipherAlgorithm predefined = CipherAlgorithm.valueOf((String)algorithm);
            user.setPassword(password, predefined);
        }
        catch (IllegalArgumentException e) {
            SyncopeClientException invalidCiperAlgorithm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.NotFound);
            invalidCiperAlgorithm.getElements().add(e.getMessage());
            scce.addException(invalidCiperAlgorithm);
            throw scce;
        }
    }

    public void create(User user, UserTO userTO, boolean storePassword) {
        Object securityQuestion;
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        user.setUsername(userTO.getUsername());
        if (StringUtils.isBlank((CharSequence)userTO.getPassword()) || !storePassword) {
            LOG.debug("Password was not provided or not required to be stored");
        } else {
            this.setPassword(user, userTO.getPassword(), scce);
        }
        user.setMustChangePassword(userTO.isMustChangePassword());
        if (userTO.getSecurityQuestion() != null && (securityQuestion = this.securityQuestionDAO.find(userTO.getSecurityQuestion())) != null) {
            user.setSecurityQuestion((SecurityQuestion)securityQuestion);
        }
        user.setSecurityAnswer(userTO.getSecurityAnswer());
        for (String roleKey : userTO.getRoles()) {
            Role role = this.roleDAO.find(roleKey);
            if (role == null) {
                LOG.warn("Ignoring unknown role with id {}", (Object)roleKey);
                continue;
            }
            user.add(role);
        }
        Realm realm = this.realmDAO.findByFullPath(userTO.getRealm());
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + userTO.getRealm());
            scce.addException(noRealm);
        }
        user.setRealm(realm);
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
        if (user.getRealm() != null) {
            for (RelationshipTO relationshipTO : userTO.getRelationships()) {
                AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(relationshipTO.getOtherEndKey());
                if (otherEnd == null) {
                    LOG.debug("Ignoring invalid anyObject " + relationshipTO.getOtherEndKey());
                    continue;
                }
                if (user.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                    RelationshipType relationshipType = this.relationshipTypeDAO.find(relationshipTO.getType());
                    if (relationshipType == null) {
                        LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType());
                        continue;
                    }
                    URelationship relationship = (URelationship)this.entityFactory.newEntity(URelationship.class);
                    relationship.setType(relationshipType);
                    relationship.setRightEnd((Any)otherEnd);
                    relationship.setLeftEnd((Any)user);
                    user.add((Relationship)relationship);
                    continue;
                }
                LOG.error("{} cannot be assigned to {}", (Object)otherEnd, (Object)user);
                SyncopeClientException unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                unassignabled.getElements().add("Cannot be assigned: " + otherEnd);
                scce.addException(unassignabled);
            }
            for (MembershipTO membershipTO : userTO.getMemberships()) {
                Group group;
                Group group2 = group = membershipTO.getGroupKey() == null ? this.groupDAO.findByName(membershipTO.getGroupName()) : (Group)this.groupDAO.find(membershipTO.getGroupKey());
                if (group == null) {
                    LOG.debug("Ignoring invalid group " + membershipTO.getGroupKey() + " / " + membershipTO.getGroupName());
                    continue;
                }
                if (user.getRealm().getFullPath().startsWith(group.getRealm().getFullPath())) {
                    UMembership membership = (UMembership)this.entityFactory.newEntity(UMembership.class);
                    membership.setRightEnd((Any)group);
                    membership.setLeftEnd((Any)user);
                    user.add((Membership)membership);
                    this.fill((Any)user, (Membership)membership, membershipTO, anyUtils, scce);
                    continue;
                }
                LOG.error("{} cannot be assigned to {}", (Object)group, (Object)user);
                SyncopeClientException unassignable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                unassignable.getElements().add("Cannot be assigned: " + group);
                scce.addException(unassignable);
            }
        }
        this.fill((Any)user, (AnyTO)userTO, anyUtils, scce);
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    private boolean isPasswordMapped(ExternalResource resource) {
        boolean result = false;
        Provision provision = resource.getProvision(this.anyTypeDAO.findUser());
        if (provision != null && provision.getMapping() != null) {
            result = IterableUtils.matchesAny((Iterable)provision.getMapping().getItems(), (Predicate)new Predicate<MappingItem>(){

                public boolean evaluate(MappingItem item) {
                    return item.isPassword();
                }
            });
        }
        return result;
    }

    public PropagationByResource update(User toBeUpdated, UserPatch userPatch) {
        User user = (User)this.userDAO.save((Any)toBeUpdated);
        PropagationByResource propByRes = new PropagationByResource();
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
        Collection currentResources = this.userDAO.findAllResourceKeys(user.getKey());
        Map<String, String> oldConnObjectKeys = this.getConnObjectKeys((Any<?>)user, anyUtils);
        this.setRealm((Any<?>)user, (AnyPatch)userPatch);
        if (userPatch.getPassword() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)userPatch.getPassword().getValue()))) {
            if (userPatch.getPassword().isOnSyncope()) {
                this.setPassword(user, (String)userPatch.getPassword().getValue(), scce);
                user.setChangePwdDate(new Date());
            }
            propByRes.addAll(ResourceOperation.UPDATE, (Collection)userPatch.getPassword().getResources());
        }
        if (userPatch.getUsername() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)userPatch.getUsername().getValue()))) {
            AccessToken accessToken;
            String oldUsername = user.getUsername();
            user.setUsername((String)userPatch.getUsername().getValue());
            if (oldUsername.equals(AuthContextUtils.getUsername())) {
                AuthContextUtils.updateUsername((String)((String)userPatch.getUsername().getValue()));
            }
            if ((accessToken = this.accessTokenDAO.findByOwner(oldUsername)) != null) {
                accessToken.setOwner((String)userPatch.getUsername().getValue());
                this.accessTokenDAO.save(accessToken);
            }
            propByRes.addAll(ResourceOperation.UPDATE, currentResources);
        }
        if (userPatch.getSecurityQuestion() != null) {
            if (userPatch.getSecurityQuestion().getValue() == null) {
                user.setSecurityQuestion(null);
                user.setSecurityAnswer(null);
            } else {
                SecurityQuestion securityQuestion = this.securityQuestionDAO.find((String)userPatch.getSecurityQuestion().getValue());
                if (securityQuestion != null) {
                    user.setSecurityQuestion(securityQuestion);
                    user.setSecurityAnswer((String)userPatch.getSecurityAnswer().getValue());
                }
            }
        }
        if (userPatch.getMustChangePassword() != null) {
            user.setMustChangePassword(((Boolean)userPatch.getMustChangePassword().getValue()).booleanValue());
        }
        block3: for (StringPatchItem patch : userPatch.getRoles()) {
            Role role = this.roleDAO.find((String)patch.getValue());
            if (role == null) {
                LOG.warn("Ignoring unknown role with key {}", patch.getValue());
                continue;
            }
            switch (patch.getOperation()) {
                case ADD_REPLACE: {
                    user.add(role);
                    continue block3;
                }
            }
            user.getRoles().remove(role);
        }
        propByRes.merge(this.fill((Any)user, (AnyPatch)userPatch, anyUtils, scce));
        for (StringPatchItem patch : userPatch.getRelationships()) {
            if (patch.getRelationshipTO() == null) continue;
            RelationshipType relationshipType = this.relationshipTypeDAO.find(patch.getRelationshipTO().getType());
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch.getRelationshipTO().getType());
                continue;
            }
            URelationship relationship = (URelationship)user.getRelationship(relationshipType, patch.getRelationshipTO().getOtherEndKey());
            if (relationship != null) {
                user.getRelationships().remove(relationship);
                relationship.setLeftEnd(null);
            }
            if (patch.getOperation() != PatchOperation.ADD_REPLACE) continue;
            AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(patch.getRelationshipTO().getOtherEndKey());
            if (otherEnd == null) {
                LOG.debug("Ignoring invalid any object {}", (Object)patch.getRelationshipTO().getOtherEndKey());
                continue;
            }
            if (user.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                relationship = (URelationship)this.entityFactory.newEntity(URelationship.class);
                relationship.setType(relationshipType);
                relationship.setRightEnd((Any)otherEnd);
                relationship.setLeftEnd((Any)user);
                user.add((Relationship)relationship);
                continue;
            }
            LOG.error("{} cannot be assigned to {}", (Object)otherEnd, (Object)user);
            SyncopeClientException unassignable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
            unassignable.getElements().add("Cannot be assigned: " + otherEnd);
            scce.addException(unassignable);
        }
        Collection resources = this.userDAO.findAllResources(user);
        HashMap reasons = new HashMap();
        for (ExternalResource resource : user.getResources()) {
            reasons.put(resource.getKey(), new HashSet<String>(Collections.singleton(user.getKey())));
        }
        for (String group : this.userDAO.findAllGroupKeys(user)) {
            for (Object resource : this.groupDAO.findAllResourceKeys(group)) {
                if (!reasons.containsKey(resource)) {
                    reasons.put(resource, new HashSet());
                }
                ((Set)reasons.get(resource)).add(group);
            }
        }
        HashSet toBeDeprovisioned = new HashSet();
        HashSet toBeProvisioned = new HashSet();
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        for (MembershipPatch membPatch : userPatch.getMemberships()) {
            if (membPatch.getGroup() == null) continue;
            UMembership uMembership = (UMembership)user.getMembership(membPatch.getGroup());
            if (uMembership != null) {
                user.getMemberships().remove(uMembership);
                uMembership.setLeftEnd(null);
                for (UPlainAttr attr : user.getPlainAttrs((Membership)uMembership)) {
                    user.remove((GroupablePlainAttr)attr);
                    attr.setOwner(null);
                    attr.setMembership(null);
                }
                if (membPatch.getOperation() == PatchOperation.DELETE) {
                    for (Object resource : this.groupDAO.findAllResourceKeys(((Group)uMembership.getRightEnd()).getKey())) {
                        if (!reasons.containsKey(resource)) continue;
                        ((Set)reasons.get(resource)).remove(((Group)uMembership.getRightEnd()).getKey());
                        toBeProvisioned.add(resource);
                    }
                }
            }
            if (membPatch.getOperation() != PatchOperation.ADD_REPLACE) continue;
            Group group = (Group)this.groupDAO.find(membPatch.getGroup());
            if (group == null) {
                LOG.debug("Ignoring invalid group {}", (Object)membPatch.getGroup());
                continue;
            }
            if (user.getRealm().getFullPath().startsWith(group.getRealm().getFullPath())) {
                Object resource;
                UMembership uMembership2 = (UMembership)this.entityFactory.newEntity(UMembership.class);
                uMembership2.setRightEnd((Any)group);
                uMembership2.setLeftEnd((Any)user);
                user.add((Membership)uMembership2);
                resource = membPatch.getPlainAttrs().iterator();
                while (resource.hasNext()) {
                    AttrTO attrTO = (AttrTO)resource.next();
                    PlainSchema schema = this.getPlainSchema(attrTO.getSchema());
                    if (schema == null) {
                        LOG.debug("Invalid " + PlainSchema.class.getSimpleName() + "{}, ignoring...", (Object)attrTO.getSchema());
                        continue;
                    }
                    UPlainAttr attr = (UPlainAttr)user.getPlainAttr(schema.getKey(), (Membership)uMembership2);
                    if (attr != null) continue;
                    LOG.debug("No plain attribute found for {} and membership of {}", (Object)schema, (Object)uMembership2.getRightEnd());
                    attr = (UPlainAttr)anyUtils.newPlainAttr();
                    attr.setOwner((Any)user);
                    attr.setMembership((Membership)uMembership2);
                    attr.setSchema(schema);
                    user.add((GroupablePlainAttr)attr);
                    AttrPatch patch = (AttrPatch)new AttrPatch.Builder().attrTO(attrTO).build();
                    this.processAttrPatch((Any)user, patch, schema, (PlainAttr<?>)attr, anyUtils, resources, propByRes, invalidValues);
                }
                if (!invalidValues.isEmpty()) {
                    scce.addException(invalidValues);
                }
                toBeProvisioned.addAll(this.groupDAO.findAllResourceKeys(group.getKey()));
                if (!toBeUpdated.canDecodePassword()) continue;
                if (userPatch.getPassword() == null) {
                    userPatch.setPassword(new PasswordPatch());
                }
                resource = group.getResources().iterator();
                while (resource.hasNext()) {
                    ExternalResource resource2 = (ExternalResource)resource.next();
                    if (!this.isPasswordMapped(resource2)) continue;
                    userPatch.getPassword().getResources().add(resource2.getKey());
                }
                continue;
            }
            LOG.error("{} cannot be assigned to {}", (Object)group, (Object)user);
            SyncopeClientException unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
            unassignabled.getElements().add("Cannot be assigned: " + group);
            scce.addException(unassignabled);
        }
        for (Map.Entry entry : reasons.entrySet()) {
            if (!((Set)entry.getValue()).isEmpty()) continue;
            toBeDeprovisioned.add(entry.getKey());
        }
        propByRes.addAll(ResourceOperation.DELETE, toBeDeprovisioned);
        propByRes.addAll(ResourceOperation.UPDATE, toBeProvisioned);
        if (!toBeDeprovisioned.isEmpty() || !toBeProvisioned.isEmpty()) {
            currentResources.removeAll(toBeDeprovisioned);
            propByRes.addAll(ResourceOperation.UPDATE, currentResources);
        }
        Map<String, String> newcCnnObjectKeys = this.getConnObjectKeys((Any<?>)user, anyUtils);
        for (Map.Entry entry : oldConnObjectKeys.entrySet()) {
            if (!newcCnnObjectKeys.containsKey(entry.getKey()) || ((String)entry.getValue()).equals(newcCnnObjectKeys.get(entry.getKey()))) continue;
            propByRes.addOldConnObjectKey((String)entry.getKey(), (String)entry.getValue());
            propByRes.add(ResourceOperation.UPDATE, (String)entry.getKey());
        }
        Pair dynGroupMembs = this.userDAO.saveAndGetDynGroupMembs(user);
        for (String delete : SetUtils.difference((Set)((Set)dynGroupMembs.getLeft()), (Set)((Set)dynGroupMembs.getRight()))) {
            for (ExternalResource resource2 : ((Group)this.groupDAO.find(delete)).getResources()) {
                if (propByRes.contains(resource2.getKey())) continue;
                propByRes.add(ResourceOperation.DELETE, resource2.getKey());
            }
        }
        for (String update : SetUtils.intersection((Set)((Set)dynGroupMembs.getLeft()), (Set)((Set)dynGroupMembs.getRight()))) {
            for (ExternalResource resource2 : ((Group)this.groupDAO.find(update)).getResources()) {
                if (propByRes.contains(resource2.getKey())) continue;
                propByRes.add(ResourceOperation.UPDATE, resource2.getKey());
            }
        }
        for (String create : SetUtils.difference((Set)((Set)dynGroupMembs.getRight()), (Set)((Set)dynGroupMembs.getLeft()))) {
            for (ExternalResource resource2 : ((Group)this.groupDAO.find(create)).getResources()) {
                if (propByRes.contains(resource2.getKey())) continue;
                propByRes.add(ResourceOperation.CREATE, resource2.getKey());
            }
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
        return propByRes;
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(final User user, boolean details) {
        UserTO userTO = new UserTO();
        BeanUtils.copyProperties((Object)user, (Object)userTO, (String[])IGNORE_PROPERTIES);
        userTO.setSuspended(BooleanUtils.isTrue((Boolean)user.isSuspended()));
        if (user.getSecurityQuestion() != null) {
            userTO.setSecurityQuestion(user.getSecurityQuestion().getKey());
        }
        Map virAttrValues = details ? this.virAttrHandler.getValues((Any)user) : Collections.emptyMap();
        this.fillTO((AnyTO)userTO, user.getRealm().getFullPath(), user.getAuxClasses(), user.getPlainAttrs(), this.derAttrHandler.getValues((Any)user), virAttrValues, this.userDAO.findAllResources(user), details);
        if (details) {
            userTO.getDynRealms().addAll(this.userDAO.findDynRealms(user.getKey()));
            CollectionUtils.collect((Iterable)user.getRoles(), (Transformer)EntityUtils.keyTransformer(), (Collection)userTO.getRoles());
            CollectionUtils.collect((Iterable)user.getRelationships(), (Transformer)new Transformer<URelationship, RelationshipTO>(){

                public RelationshipTO transform(URelationship relationship) {
                    return UserDataBinderImpl.this.getRelationshipTO(relationship.getType().getKey(), relationship.getRightEnd());
                }
            }, (Collection)userTO.getRelationships());
            CollectionUtils.collect((Iterable)user.getMemberships(), (Transformer)new Transformer<UMembership, MembershipTO>(){

                public MembershipTO transform(UMembership membership) {
                    return UserDataBinderImpl.this.getMembershipTO(user.getPlainAttrs((Membership)membership), UserDataBinderImpl.this.derAttrHandler.getValues((GroupableRelatable)user, (Membership)membership), UserDataBinderImpl.this.virAttrHandler.getValues((Any)user, (Membership)membership), (Membership<? extends Any<?>>)membership);
                }
            }, (Collection)userTO.getMemberships());
            CollectionUtils.collect((Iterable)this.userDAO.findDynRoles(user.getKey()), (Transformer)EntityUtils.keyTransformer(), (Collection)userTO.getDynRoles());
            CollectionUtils.collect((Iterable)this.userDAO.findDynGroups(user.getKey()), (Transformer)new Transformer<Group, MembershipTO>(){

                public MembershipTO transform(Group group) {
                    MembershipTO membershipTO = new MembershipTO.Builder().group(group.getKey(), group.getName()).build();
                    return membershipTO;
                }
            }, (Collection)userTO.getDynMemberships());
        }
        return userTO;
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(String key) {
        return this.getUserTO((User)this.userDAO.authFind(key), true);
    }
}

