/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTemplate;
import org.apache.syncope.core.persistence.api.entity.AnyTemplateRealm;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.RealmDataBinder;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RealmDataBinderImpl
implements RealmDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(RealmDataBinder.class);
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private PolicyDAO policyDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private TemplateUtils templateUtils;

    private void setTemplates(final RealmTO realmTO, Realm realm) {
        this.templateUtils.check(realmTO.getTemplates(), ClientExceptionType.InvalidRealm);
        for (Map.Entry entry : realmTO.getTemplates().entrySet()) {
            AnyType type = this.anyTypeDAO.find((String)entry.getKey());
            if (type == null) {
                LOG.debug("Invalid AnyType {} specified, ignoring...", entry.getKey());
                continue;
            }
            AnyTemplateRealm anyTemplate = realm.getTemplate(type);
            if (anyTemplate == null) {
                anyTemplate = (AnyTemplateRealm)this.entityFactory.newEntity(AnyTemplateRealm.class);
                anyTemplate.setAnyType(type);
                anyTemplate.setRealm(realm);
                realm.add(anyTemplate);
            }
            anyTemplate.set((AnyTO)entry.getValue());
        }
        CollectionUtils.filter((Iterable)realm.getTemplates(), (Predicate)new Predicate<AnyTemplate>(){

            public boolean evaluate(AnyTemplate anyTemplate) {
                return realmTO.getTemplates().containsKey(anyTemplate.getAnyType().getKey());
            }
        });
    }

    public Realm create(Realm parent, RealmTO realmTO) {
        Policy policy;
        Realm realm = (Realm)this.entityFactory.newEntity(Realm.class);
        realm.setName(realmTO.getName());
        realm.setParent(parent);
        if (realmTO.getPasswordPolicy() != null) {
            policy = this.policyDAO.find(realmTO.getPasswordPolicy());
            if (policy instanceof PasswordPolicy) {
                realm.setPasswordPolicy((PasswordPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + PasswordPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (realmTO.getAccountPolicy() != null) {
            policy = this.policyDAO.find(realmTO.getAccountPolicy());
            if (policy instanceof AccountPolicy) {
                realm.setAccountPolicy((AccountPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AccountPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        realm.getActionsClassNames().addAll(realmTO.getActionsClassNames());
        this.setTemplates(realmTO, realm);
        for (String resourceKey : realmTO.getResources()) {
            ExternalResource resource = this.resourceDAO.find(resourceKey);
            if (resource == null) {
                LOG.debug("Invalid " + ExternalResource.class.getSimpleName() + "{}, ignoring...", (Object)resourceKey);
                continue;
            }
            realm.add(resource);
        }
        return realm;
    }

    public PropagationByResource update(Realm realm, final RealmTO realmTO) {
        Policy policy;
        realm.setName(realmTO.getName());
        realm.setParent(realmTO.getParent() == null ? null : this.realmDAO.find(realmTO.getParent()));
        if (realmTO.getAccountPolicy() == null) {
            realm.setAccountPolicy(null);
        } else {
            policy = this.policyDAO.find(realmTO.getAccountPolicy());
            if (policy instanceof AccountPolicy) {
                realm.setAccountPolicy((AccountPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AccountPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (realmTO.getPasswordPolicy() == null) {
            realm.setPasswordPolicy(null);
        } else {
            policy = this.policyDAO.find(realmTO.getPasswordPolicy());
            if (policy instanceof PasswordPolicy) {
                realm.setPasswordPolicy((PasswordPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + PasswordPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        realm.getActionsClassNames().clear();
        realm.getActionsClassNames().addAll(realmTO.getActionsClassNames());
        this.setTemplates(realmTO, realm);
        final PropagationByResource propByRes = new PropagationByResource();
        for (String resourceKey : realmTO.getResources()) {
            ExternalResource resource = this.resourceDAO.find(resourceKey);
            if (resource == null) {
                LOG.debug("Invalid " + ExternalResource.class.getSimpleName() + "{}, ignoring...", (Object)resourceKey);
                continue;
            }
            realm.add(resource);
            propByRes.add(ResourceOperation.CREATE, resource.getKey());
        }
        CollectionUtils.filter((Iterable)realm.getResources(), (Predicate)new Predicate<ExternalResource>(){

            public boolean evaluate(ExternalResource resource) {
                boolean contained = realmTO.getResources().contains(resource.getKey());
                if (!contained) {
                    propByRes.add(ResourceOperation.DELETE, resource.getKey());
                }
                return contained;
            }
        });
        return propByRes;
    }

    public RealmTO getRealmTO(Realm realm, boolean admin) {
        RealmTO realmTO = new RealmTO();
        realmTO.setKey(realm.getKey());
        realmTO.setName(realm.getName());
        realmTO.setParent(realm.getParent() == null ? null : realm.getParent().getKey());
        realmTO.setFullPath(realm.getFullPath());
        if (admin) {
            realmTO.setAccountPolicy(realm.getAccountPolicy() == null ? null : realm.getAccountPolicy().getKey());
            realmTO.setPasswordPolicy(realm.getPasswordPolicy() == null ? null : realm.getPasswordPolicy().getKey());
            realmTO.getActionsClassNames().addAll(realm.getActionsClassNames());
            for (AnyTemplate template : realm.getTemplates()) {
                realmTO.getTemplates().put(template.getAnyType().getKey(), template.get());
            }
            for (ExternalResource resource : realm.getResources()) {
                realmTO.getResources().add(resource.getKey());
            }
        }
        return realmTO;
    }
}

