/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.text.ParseException;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.to.NotificationTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.MailTemplateDAO;
import org.apache.syncope.core.persistence.api.entity.AnyAbout;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.MailTemplate;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.provisioning.api.data.NotificationDataBinder;
import org.apache.syncope.core.provisioning.java.IntAttrNameParser;
import org.apache.syncope.core.spring.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationDataBinderImpl
implements NotificationDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationDataBinder.class);
    private static final String[] IGNORE_PROPERTIES = new String[]{"key", "template", "abouts"};
    @Autowired
    private MailTemplateDAO mailTemplateDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private IntAttrNameParser intAttrNameParser;

    public NotificationTO getNotificationTO(Notification notification) {
        NotificationTO result = new NotificationTO();
        result.setKey(notification.getKey());
        result.setTemplate(notification.getTemplate().getKey());
        BeanUtils.copyProperties((Object)notification, (Object)result, (String[])IGNORE_PROPERTIES);
        for (AnyAbout about : notification.getAbouts()) {
            result.getAbouts().put(about.getAnyType().getKey(), about.get());
        }
        return result;
    }

    public Notification create(NotificationTO notificationTO) {
        Notification result = (Notification)this.entityFactory.newEntity(Notification.class);
        this.update(result, notificationTO);
        return result;
    }

    public void update(Notification notification, final NotificationTO notificationTO) {
        BeanUtils.copyProperties((Object)notificationTO, (Object)notification, (String[])IGNORE_PROPERTIES);
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        MailTemplate template = this.mailTemplateDAO.find(notificationTO.getTemplate());
        if (template == null) {
            sce.getElements().add("template");
        }
        notification.setTemplate(template);
        if (notification.getEvents().isEmpty()) {
            sce.getElements().add("events");
        }
        if (!notification.getStaticRecipients().isEmpty()) {
            for (String string : notification.getStaticRecipients()) {
                Matcher matcher = SyncopeConstants.EMAIL_PATTERN.matcher(string);
                if (matcher.matches()) continue;
                LOG.error("Invalid mail address: {}", (Object)string);
                sce.getElements().add("staticRecipients: " + string);
            }
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
        for (Map.Entry entry : notificationTO.getAbouts().entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            AnyType anyType = this.anyTypeDAO.find((String)entry.getKey());
            if (anyType == null) {
                LOG.debug("Invalid AnyType {} specified, ignoring...", entry.getKey());
                continue;
            }
            AnyAbout about = notification.getAbout(anyType);
            if (about == null) {
                about = (AnyAbout)this.entityFactory.newEntity(AnyAbout.class);
                about.setAnyType(anyType);
                about.setNotification(notification);
                notification.add(about);
            }
            about.set((String)entry.getValue());
        }
        CollectionUtils.filter((Iterable)notification.getAbouts(), (Predicate)new Predicate<AnyAbout>(){

            public boolean evaluate(AnyAbout anyAbout) {
                return notificationTO.getAbouts().containsKey(anyAbout.getAnyType().getKey());
            }
        });
        try {
            this.intAttrNameParser.parse(notification.getRecipientAttrName(), AnyTypeKind.USER);
        }
        catch (ParseException e) {
            sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }
}

