/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Iterator;
import java.util.Map;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.DynRealmMembership;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.provisioning.api.data.DynRealmDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynRealmDataBinderImpl
implements DynRealmDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(DynRealmDataBinder.class);
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private DynRealmDAO dynRealmDAO;
    @Autowired
    private EntityFactory entityFactory;

    private void setDynMembership(DynRealm dynRealm, AnyType anyType, String dynMembershipFIQL) {
        DynRealmMembership dynMembership;
        SearchCond dynMembershipCond = SearchCondConverter.convert((String)dynMembershipFIQL, (String[])new String[0]);
        if (!dynMembershipCond.isValid()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchExpression);
            sce.getElements().add(dynMembershipFIQL);
            throw sce;
        }
        if (dynRealm.getDynMembership(anyType) == null) {
            dynMembership = (DynRealmMembership)this.entityFactory.newEntity(DynRealmMembership.class);
            dynMembership.setDynRealm(dynRealm);
            dynMembership.setAnyType(anyType);
            dynRealm.add(dynMembership);
        } else {
            dynMembership = dynRealm.getDynMembership(anyType);
        }
        dynMembership.setFIQLCond(dynMembershipFIQL);
    }

    public DynRealm create(DynRealmTO dynRealmTO) {
        return this.update((DynRealm)this.entityFactory.newEntity(DynRealm.class), dynRealmTO);
    }

    public DynRealm update(DynRealm toBeUpdated, DynRealmTO dynRealmTO) {
        toBeUpdated.setKey(dynRealmTO.getKey());
        DynRealm dynRealm = this.dynRealmDAO.save(toBeUpdated);
        Iterator itor = dynRealm.getDynMemberships().iterator();
        while (itor.hasNext()) {
            DynRealmMembership memb = (DynRealmMembership)itor.next();
            memb.setDynRealm(null);
            itor.remove();
        }
        this.dynRealmDAO.clearDynMembers(dynRealm);
        for (Map.Entry entry : dynRealmTO.getDynMembershipConds().entrySet()) {
            AnyType anyType = this.anyTypeDAO.find((String)entry.getKey());
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), entry.getKey());
                continue;
            }
            this.setDynMembership(dynRealm, anyType, (String)entry.getValue());
        }
        return this.dynRealmDAO.save(dynRealm);
    }

    public DynRealmTO getDynRealmTO(DynRealm dynRealm) {
        DynRealmTO dynRealmTO = new DynRealmTO();
        dynRealmTO.setKey(dynRealm.getKey());
        for (DynRealmMembership memb : dynRealm.getDynMemberships()) {
            dynRealmTO.getDynMembershipConds().put(memb.getAnyType().getKey(), memb.getFIQLCond());
        }
        return dynRealmTO;
    }
}

