/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collections;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.provisioning.api.data.AnyTypeClassDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnyTypeClassDataBinderImpl
implements AnyTypeClassDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(AnyTypeClassDataBinder.class);
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private DerSchemaDAO derSchemaDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private EntityFactory entityFactory;

    public AnyTypeClass create(AnyTypeClassTO anyTypeClassTO) {
        AnyTypeClass anyTypeClass = (AnyTypeClass)this.entityFactory.newEntity(AnyTypeClass.class);
        this.update(anyTypeClass, anyTypeClassTO);
        return anyTypeClass;
    }

    public void update(AnyTypeClass anyTypeClass, AnyTypeClassTO anyTypeClassTO) {
        PlainSchema schema;
        if (anyTypeClass.getKey() == null) {
            anyTypeClass.setKey(anyTypeClassTO.getKey());
        }
        for (PlainSchema schema2 : this.plainSchemaDAO.findByAnyTypeClasses(Collections.singletonList(anyTypeClass))) {
            schema2.setAnyTypeClass(null);
        }
        anyTypeClass.getPlainSchemas().clear();
        for (String schemaName : anyTypeClassTO.getPlainSchemas()) {
            schema = (PlainSchema)this.plainSchemaDAO.find(schemaName);
            if (schema == null || schema.getAnyTypeClass() != null) {
                LOG.debug("Invalid or already in use" + PlainSchema.class.getSimpleName() + "{}, ignoring...", (Object)schemaName);
                continue;
            }
            anyTypeClass.add(schema);
        }
        for (PlainSchema schema2 : this.derSchemaDAO.findByAnyTypeClasses(Collections.singletonList(anyTypeClass))) {
            schema2.setAnyTypeClass(null);
        }
        anyTypeClass.getDerSchemas().clear();
        for (String schemaName : anyTypeClassTO.getDerSchemas()) {
            schema = (DerSchema)this.derSchemaDAO.find(schemaName);
            if (schema == null || schema.getAnyTypeClass() != null) {
                LOG.debug("Invalid or already in use" + DerSchema.class.getSimpleName() + "{}, ignoring...", (Object)schemaName);
                continue;
            }
            anyTypeClass.add((DerSchema)schema);
        }
        for (PlainSchema schema2 : this.virSchemaDAO.findByAnyTypeClasses(Collections.singletonList(anyTypeClass))) {
            schema2.setAnyTypeClass(null);
        }
        anyTypeClass.getVirSchemas().clear();
        for (String schemaName : anyTypeClassTO.getVirSchemas()) {
            schema = (VirSchema)this.virSchemaDAO.find(schemaName);
            if (schema == null || schema.getAnyTypeClass() != null) {
                LOG.debug("Invalid or already in use" + VirSchema.class.getSimpleName() + "{}, ignoring...", (Object)schemaName);
                continue;
            }
            anyTypeClass.add((VirSchema)schema);
        }
    }

    public AnyTypeClassTO getAnyTypeClassTO(AnyTypeClass anyTypeClass) {
        AnyTypeClassTO anyTypeClassTO = new AnyTypeClassTO();
        anyTypeClassTO.setKey(anyTypeClass.getKey());
        for (AnyType anyType : this.anyTypeDAO.findByTypeClass(anyTypeClass)) {
            anyTypeClassTO.getInUseByTypes().add(anyType.getKey());
        }
        for (PlainSchema schema : anyTypeClass.getPlainSchemas()) {
            anyTypeClassTO.getPlainSchemas().add(schema.getKey());
        }
        for (PlainSchema schema : anyTypeClass.getDerSchemas()) {
            anyTypeClassTO.getDerSchemas().add(schema.getKey());
        }
        for (PlainSchema schema : anyTypeClass.getVirSchemas()) {
            anyTypeClassTO.getVirSchemas().add(schema.getKey());
        }
        return anyTypeClassTO;
    }
}

