/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.apache.syncope.core.persistence.api.dao.LoggerDAO;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.java.AuditEntry;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Component
public class AuditManagerImpl
implements AuditManager {
    @Autowired
    private LoggerDAO loggerDAO;

    public boolean auditRequested(AuditElements.EventCategoryType type, String category, String subcategory, String event) {
        boolean auditRequested;
        AuditEntry auditEntry = new AuditEntry(AuthContextUtils.getUsername(), new AuditLoggerName(type, category, subcategory, event, AuditElements.Result.SUCCESS), null, null, null);
        org.apache.syncope.core.persistence.api.entity.Logger syncopeLogger = this.loggerDAO.find(auditEntry.getLogger().toLoggerName());
        boolean bl = auditRequested = syncopeLogger != null && syncopeLogger.getLevel() == LoggerLevel.DEBUG;
        if (auditRequested) {
            return true;
        }
        auditEntry = new AuditEntry(AuthContextUtils.getUsername(), new AuditLoggerName(type, category, subcategory, event, AuditElements.Result.FAILURE), null, null, null);
        syncopeLogger = this.loggerDAO.find(auditEntry.getLogger().toLoggerName());
        auditRequested = syncopeLogger != null && syncopeLogger.getLevel() == LoggerLevel.DEBUG;
        return auditRequested;
    }

    public void audit(AfterHandlingEvent event) {
        this.audit(event.getType(), event.getCategory(), event.getSubcategory(), event.getEvent(), event.getCondition(), event.getBefore(), event.getOutput(), event.getInput());
    }

    public void audit(AuditElements.EventCategoryType type, String category, String subcategory, String event, AuditElements.Result condition, Object before, Object output, Object ... input) {
        AuditEntry auditEntry;
        org.apache.syncope.core.persistence.api.entity.Logger syncopeLogger;
        Throwable throwable = null;
        if (output instanceof Throwable) {
            throwable = (Throwable)output;
        }
        if ((syncopeLogger = this.loggerDAO.find((auditEntry = new AuditEntry(AuthContextUtils.getUsername(), new AuditLoggerName(type, category, subcategory, event, condition), before, throwable == null ? output : throwable.getMessage(), input)).getLogger().toLoggerName())) != null && syncopeLogger.getLevel() == LoggerLevel.DEBUG) {
            Logger logger = LoggerFactory.getLogger((String)AuditLoggerName.getAuditLoggerName((String)AuthContextUtils.getDomain()));
            Logger eventLogger = LoggerFactory.getLogger((String)AuditLoggerName.getAuditEventLoggerName((String)AuthContextUtils.getDomain(), (String)syncopeLogger.getKey()));
            String serializedAuditEntry = POJOHelper.serialize((Object)((Object)auditEntry));
            if (throwable == null) {
                logger.debug(serializedAuditEntry);
                eventLogger.debug(POJOHelper.serialize((Object)((Object)auditEntry)));
            } else {
                logger.debug(serializedAuditEntry, throwable);
                eventLogger.debug(serializedAuditEntry, throwable);
            }
        }
    }
}

