/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AuditLoggerName;

public class AuditEntry
extends AbstractBaseBean {
    private static final long serialVersionUID = -2299082316063743582L;
    private final String who;
    private final AuditLoggerName logger;
    private final Object before;
    private final Object output;
    private final Object[] input;

    @JsonCreator
    public AuditEntry(@JsonProperty(value="who") String who, @JsonProperty(value="logger") AuditLoggerName logger, @JsonProperty(value="before") Object before, @JsonProperty(value="output") Object output, @JsonProperty(value="input") Object[] input) {
        this.who = who;
        this.logger = logger;
        this.before = this.filterUserPassword(before);
        this.output = this.filterUserPassword(output);
        this.input = ArrayUtils.clone((Object[])input);
        if (this.input != null) {
            for (int i = 0; i < this.input.length; ++i) {
                this.input[i] = this.filterUserPassword(this.input[i]);
            }
        }
    }

    private Object filterUserPassword(Object object) {
        Object filtered;
        if (object instanceof UserTO) {
            UserTO user = (UserTO)SerializationUtils.clone((Serializable)((UserTO)object));
            user.setPassword(null);
            filtered = user;
        } else {
            filtered = object;
        }
        return filtered;
    }

    public String getWho() {
        return this.who;
    }

    public AuditLoggerName getLogger() {
        return this.logger;
    }

    public Object getBefore() {
        return this.before;
    }

    public Object getOutput() {
        return this.output;
    }

    public Object[] getInput() {
        return this.input;
    }
}

