/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;

public final class RealmUtils {
    public static String getGroupOwnerRealm(String realmPath, String groupKey) {
        return realmPath + "@" + groupKey;
    }

    public static boolean normalizingAddTo(Set<String> realms, String newRealm) {
        boolean dontAdd = false;
        HashSet<String> toRemove = new HashSet<String>();
        for (String realm : realms) {
            if (newRealm.startsWith(realm)) {
                dontAdd = true;
                continue;
            }
            if (!realm.startsWith(newRealm)) continue;
            toRemove.add(realm);
        }
        realms.removeAll(toRemove);
        if (!dontAdd) {
            realms.add(newRealm);
        }
        return !dontAdd;
    }

    public static Set<String> normalize(Collection<String> realms) {
        HashSet<String> normalized = new HashSet<String>();
        if (realms != null) {
            for (String realm : realms) {
                RealmUtils.normalizingAddTo(normalized, realm);
            }
        }
        return normalized;
    }

    public static Set<String> getEffective(Set<String> allowedRealms, String requestedRealm) {
        Set<String> allowed = RealmUtils.normalize(allowedRealms);
        HashSet<String> requested = new HashSet<String>();
        requested.add(requestedRealm);
        HashSet<String> effective = new HashSet<String>();
        CollectionUtils.select(requested, (Predicate)new StartsWithPredicate(allowed), effective);
        CollectionUtils.select(allowed, (Predicate)new StartsWithPredicate(requested), effective);
        CollectionUtils.select(allowedRealms, (Predicate)new DynRealmsPredicate(), effective);
        return effective;
    }

    private RealmUtils() {
    }

    public static class DynRealmsPredicate
    implements Predicate<String> {
        public boolean evaluate(String realm) {
            return !realm.startsWith("/");
        }
    }

    private static class StartsWithPredicate
    implements Predicate<String> {
        private final Collection<String> targets;

        StartsWithPredicate(Collection<String> targets) {
            this.targets = targets;
        }

        public boolean evaluate(final String realm) {
            return IterableUtils.matchesAny(this.targets, (Predicate)new Predicate<String>(){

                public boolean evaluate(String target) {
                    return realm.startsWith(target);
                }
            });
        }
    }
}

