/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.syncope.common.lib.SyncopeConstants;

public final class FormatUtils {
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.applyPattern("yyyy-MM-dd'T'HH:mm:ssZ");
            return sdf;
        }
    };
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            DecimalFormat df = new DecimalFormat();
            df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
            return df;
        }
    };

    public static String format(Date date) {
        return FormatUtils.format(date, true);
    }

    public static String format(Date date, boolean lenient) {
        return FormatUtils.format(date, lenient, null);
    }

    public static String format(Date date, boolean lenient, String conversionPattern) {
        SimpleDateFormat sdf = DATE_FORMAT.get();
        if (conversionPattern != null) {
            sdf.applyPattern(conversionPattern);
        }
        sdf.setLenient(lenient);
        return sdf.format(date);
    }

    public static String format(long number) {
        return FormatUtils.format(number, null);
    }

    public static String format(long number, String conversionPattern) {
        DecimalFormat df = DECIMAL_FORMAT.get();
        if (conversionPattern != null) {
            df.applyPattern(conversionPattern);
        }
        return df.format(number);
    }

    public static String format(double number) {
        return FormatUtils.format(number, null);
    }

    public static String format(double number, String conversionPattern) {
        DecimalFormat df = DECIMAL_FORMAT.get();
        if (conversionPattern != null) {
            df.applyPattern(conversionPattern);
        }
        return df.format(number);
    }

    public static Date parseDate(String source) throws ParseException {
        return DateUtils.parseDate((String)source, (String[])SyncopeConstants.DATE_PATTERNS);
    }

    public static Date parseDate(String source, String conversionPattern) throws ParseException {
        SimpleDateFormat sdf = DATE_FORMAT.get();
        sdf.applyPattern(conversionPattern);
        sdf.setLenient(false);
        return sdf.parse(source);
    }

    public static Number parseNumber(String source, String conversionPattern) throws ParseException {
        DecimalFormat df = DECIMAL_FORMAT.get();
        df.applyPattern(conversionPattern);
        return df.parse(source);
    }

    public static void clear() {
        DATE_FORMAT.remove();
        DECIMAL_FORMAT.remove();
    }

    private FormatUtils() {
    }
}

