/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.identityconnectors.common.Base64;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;

class AttributeSerializer
extends JsonSerializer<Attribute> {
    public static final String BYTE_ARRAY_PREFIX = "<binary>";
    public static final String BYTE_ARRAY_SUFFIX = "</binary>";

    AttributeSerializer() {
    }

    public void serialize(Attribute source, JsonGenerator jgen, SerializerProvider sp) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("name", source.getName());
        jgen.writeFieldName("value");
        if (source.getValue() == null) {
            jgen.writeNull();
        } else {
            jgen.writeStartArray();
            for (Object value : source.getValue()) {
                if (value == null) {
                    jgen.writeNull();
                    continue;
                }
                if (value instanceof GuardedString) {
                    jgen.writeObject(value);
                    continue;
                }
                if (value instanceof Integer) {
                    jgen.writeNumber(((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Long) {
                    jgen.writeNumber(((Long)value).longValue());
                    continue;
                }
                if (value instanceof Double) {
                    jgen.writeNumber(((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    jgen.writeBoolean(((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof byte[]) {
                    jgen.writeString(BYTE_ARRAY_PREFIX + Base64.encode((byte[])((byte[])value)) + BYTE_ARRAY_SUFFIX);
                    continue;
                }
                jgen.writeString(value.toString());
            }
            jgen.writeEndArray();
        }
        jgen.writeEndObject();
    }
}

