/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.to.AbstractAnnotatedBean;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;

@XmlType
@XmlSeeAlso(value={UserTO.class, GroupTO.class, AnyObjectTO.class})
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="@class")
@JsonPropertyOrder(value={"@class", "key", "type", "realm", "username", "name"})
@ApiModel(subTypes={UserTO.class, GroupTO.class, AnyObjectTO.class}, discriminator="@class")
public abstract class AnyTO
extends AbstractAnnotatedBean
implements EntityTO,
AttributableTO {
    private static final long serialVersionUID = -754311920679872084L;
    @XmlTransient
    @JsonProperty(value="@class")
    private String discriminator;
    private String key;
    private String type;
    private String realm;
    private final List<String> dynRealms = new ArrayList<String>();
    private String status;
    private final List<String> auxClasses = new ArrayList<String>();
    private final Set<AttrTO> plainAttrs = new HashSet<AttrTO>();
    private final Set<AttrTO> derAttrs = new HashSet<AttrTO>();
    private final Set<AttrTO> virAttrs = new HashSet<AttrTO>();
    private final Set<String> resources = new HashSet<String>();

    @ApiModelProperty(name="@class", required=true, readOnly=false)
    public abstract String getDiscriminator();

    public void setDiscriminator(String discriminator) {
    }

    @Override
    @ApiModelProperty(readOnly=true)
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @ApiModelProperty(readOnly=true)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    @ApiModelProperty(readOnly=true)
    @XmlElementWrapper(name="dynRealms")
    @XmlElement(name="dynRealmF")
    @JsonProperty(value="dynRealms")
    public List<String> getDynRealms() {
        return this.dynRealms;
    }

    @ApiModelProperty(readOnly=true)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @XmlElementWrapper(name="auxClasses")
    @XmlElement(name="class")
    @JsonProperty(value="auxClasses")
    public List<String> getAuxClasses() {
        return this.auxClasses;
    }

    @Override
    @XmlElementWrapper(name="plainAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="plainAttrs")
    public Set<AttrTO> getPlainAttrs() {
        return this.plainAttrs;
    }

    @Override
    @JsonIgnore
    public AttrTO getPlainAttr(final String schema) {
        return (AttrTO)IterableUtils.find(this.plainAttrs, (Predicate)new Predicate<AttrTO>(){

            public boolean evaluate(AttrTO object) {
                return object.getSchema().equals(schema);
            }
        });
    }

    @Override
    @XmlElementWrapper(name="derAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="derAttrs")
    public Set<AttrTO> getDerAttrs() {
        return this.derAttrs;
    }

    @Override
    @JsonIgnore
    public AttrTO getDerAttr(final String schema) {
        return (AttrTO)IterableUtils.find(this.derAttrs, (Predicate)new Predicate<AttrTO>(){

            public boolean evaluate(AttrTO object) {
                return object.getSchema().equals(schema);
            }
        });
    }

    @Override
    @XmlElementWrapper(name="virAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="virAttrs")
    public Set<AttrTO> getVirAttrs() {
        return this.virAttrs;
    }

    @Override
    @JsonIgnore
    public AttrTO getVirAttr(final String schema) {
        return (AttrTO)IterableUtils.find(this.virAttrs, (Predicate)new Predicate<AttrTO>(){

            public boolean evaluate(AttrTO object) {
                return object.getSchema().equals(schema);
            }
        });
    }

    @XmlElementWrapper(name="resources")
    @XmlElement(name="resource")
    @JsonProperty(value="resources")
    public Set<String> getResources() {
        return this.resources;
    }
}

