/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;

public final class EntityTOUtils {
    public static <E extends EntityTO> Transformer<E, String> keyTransformer() {
        return new Transformer<E, String>(){

            public String transform(E input) {
                return input.getKey();
            }
        };
    }

    public static Map<String, AttrTO> buildAttrMap(Collection<AttrTO> attrs) {
        HashMap<String, AttrTO> result = new HashMap<String, AttrTO>(attrs.size());
        for (AttrTO attributeTO : attrs) {
            result.put(attributeTO.getSchema(), attributeTO);
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<Pair<String, String>, RelationshipTO> buildRelationshipMap(Collection<RelationshipTO> relationships) {
        HashMap<Pair, RelationshipTO> result = new HashMap<Pair, RelationshipTO>(relationships.size());
        for (RelationshipTO relationship : relationships) {
            result.put(Pair.of((Object)relationship.getType(), (Object)relationship.getOtherEndKey()), relationship);
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, MembershipTO> buildMembershipMap(Collection<MembershipTO> memberships) {
        HashMap<String, MembershipTO> result = new HashMap<String, MembershipTO>(memberships.size());
        for (MembershipTO membership : memberships) {
            result.put(membership.getGroupKey(), membership);
        }
        return Collections.unmodifiableMap(result);
    }

    private EntityTOUtils() {
    }
}

