/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.to.WorkflowDefinitionTO;
import org.apache.syncope.common.lib.to.WorkflowFormTO;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.workflow.api.WorkflowDefinitionFormat;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.apache.syncope.core.workflow.java.AbstractUserWorkflowAdapter;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultUserWorkflowAdapter
extends AbstractUserWorkflowAdapter {
    @Autowired
    private ConfDAO confDAO;

    public boolean supportsDefinitionEdit() {
        return false;
    }

    @Override
    protected WorkflowResult<Pair<String, Boolean>> doCreate(UserTO userTO, boolean disablePwdPolicyCheck, Boolean enabled, boolean storePassword) {
        boolean propagateEnable;
        String status;
        User user = (User)this.entityFactory.newEntity(User.class);
        this.dataBinder.create(user, userTO, storePassword);
        if (disablePwdPolicyCheck) {
            user.removeClearPassword();
        }
        if (enabled == null) {
            status = "created";
            propagateEnable = true;
        } else {
            status = enabled != false ? "active" : "suspended";
            propagateEnable = enabled;
            user.setSuspended(Boolean.valueOf(enabled == false));
        }
        user.setStatus(status);
        user = (User)this.userDAO.save((Any)user);
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.CREATE, this.userDAO.findAllResourceKeys(user.getKey()));
        return new WorkflowResult((Object)Pair.of((Object)user.getKey(), (Object)propagateEnable), propByRes, "create");
    }

    @Override
    protected WorkflowResult<String> doActivate(User user, String token) {
        if (!user.checkToken(token)) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Wrong token: " + token + " for " + user));
        }
        user.removeToken();
        user.setStatus("active");
        User updated = (User)this.userDAO.save((Any)user);
        return new WorkflowResult((Object)updated.getKey(), null, "activate");
    }

    @Override
    protected WorkflowResult<Pair<UserPatch, Boolean>> doUpdate(User user, UserPatch userPatch) {
        UserTO original = this.dataBinder.getUserTO(user, true);
        PropagationByResource propByRes = this.dataBinder.update(user, userPatch);
        PasswordPatch password = userPatch.getPassword();
        Set virAttrs = userPatch.getVirAttrs();
        UserTO updated = this.dataBinder.getUserTO((User)this.userDAO.save((Any)user), true);
        UserPatch effectivePatch = AnyOperations.diff((UserTO)updated, (UserTO)original, (boolean)false);
        effectivePatch.setPassword(password);
        effectivePatch.getVirAttrs().clear();
        effectivePatch.getVirAttrs().addAll(virAttrs);
        return new WorkflowResult((Object)Pair.of((Object)effectivePatch, (Object)(user.isSuspended() == false ? 1 : 0)), propByRes, "update");
    }

    @Override
    protected WorkflowResult<String> doSuspend(User user) {
        user.setStatus("suspended");
        User updated = (User)this.userDAO.save((Any)user);
        return new WorkflowResult((Object)updated.getKey(), null, "suspend");
    }

    @Override
    protected WorkflowResult<String> doReactivate(User user) {
        user.setStatus("active");
        User updated = (User)this.userDAO.save((Any)user);
        return new WorkflowResult((Object)updated.getKey(), null, "reactivate");
    }

    @Override
    protected void doRequestPasswordReset(User user) {
        user.generateToken(((Long)this.confDAO.find("token.length", (Object)256L)).intValue(), ((Long)this.confDAO.find("token.expireTime", (Object)60L)).intValue());
        this.userDAO.save((Any)user);
    }

    @Override
    protected WorkflowResult<Pair<UserPatch, Boolean>> doConfirmPasswordReset(User user, String token, String password) {
        if (!user.checkToken(token)) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Wrong token: " + token + " for " + user));
        }
        user.removeToken();
        UserPatch userPatch = new UserPatch();
        userPatch.setKey(user.getKey());
        userPatch.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().onSyncope(true).resources(this.userDAO.findAllResourceKeys(user.getKey())).value((Object)password)).build());
        return this.doUpdate(user, userPatch);
    }

    @Override
    protected void doDelete(User user) {
        this.userDAO.delete((Any)user);
    }

    public WorkflowResult<String> execute(UserTO userTO, String taskId) {
        throw new WorkflowException((Throwable)new UnsupportedOperationException("Not supported."));
    }

    public List<WorkflowFormTO> getForms() {
        return Collections.emptyList();
    }

    public WorkflowFormTO getForm(String workflowId) {
        return null;
    }

    public WorkflowFormTO claimForm(String taskId) {
        throw new WorkflowException((Throwable)new UnsupportedOperationException("Not supported."));
    }

    public WorkflowResult<UserPatch> submitForm(WorkflowFormTO form) {
        throw new WorkflowException((Throwable)new UnsupportedOperationException("Not supported."));
    }

    public WorkflowResult<String> requestCertify(User user) {
        throw new WorkflowException((Throwable)new UnsupportedOperationException("Not supported."));
    }

    public List<WorkflowDefinitionTO> getDefinitions() {
        throw new WorkflowException((Throwable)new UnsupportedOperationException("Not supported."));
    }

    public void exportDefinition(String key, WorkflowDefinitionFormat format, OutputStream os) {
        throw new WorkflowException((Throwable)new UnsupportedOperationException("Not supported."));
    }

    public void exportDiagram(String key, OutputStream os) {
        throw new WorkflowException((Throwable)new UnsupportedOperationException("Not supported."));
    }

    public void importDefinition(String key, WorkflowDefinitionFormat format, String definition) {
        throw new WorkflowException((Throwable)new UnsupportedOperationException("Not supported."));
    }

    public void deleteDefinition(String key) {
        throw new WorkflowException((Throwable)new UnsupportedOperationException("Not supported."));
    }
}

