/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.camel.util.jsse.BaseSSLContextParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextClientParameters
extends BaseSSLContextParameters {
    private static final Logger LOG = LoggerFactory.getLogger(SSLContextClientParameters.class);

    @Override
    protected boolean getAllowPassthrough() {
        return true;
    }

    @Override
    protected void configureSSLContext(SSLContext context) throws GeneralSecurityException {
        LOG.trace("Configuring client-side SSLContext parameters on SSLContext [{}]...", (Object)context);
        if (this.getSessionTimeout() != null) {
            LOG.info("Configuring client-side SSLContext session timeout on SSLContext [{}] to [{}].", (Object)context, (Object)this.getSessionTimeout());
            this.configureSessionContext(context.getClientSessionContext(), this.getSessionTimeout());
        }
        LOG.trace("Configured client-side SSLContext parameters on SSLContext [{}].", (Object)context);
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLEngine>> getSSLEngineConfigurers(SSLContext context) {
        return Collections.emptyList();
    }

    @Override
    protected List<BaseSSLContextParameters.Configurer<SSLServerSocketFactory>> getSSLServerSocketFactoryConfigurers(SSLContext context) {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SSLContextClientParameters[getCipherSuites()=");
        builder.append(this.getCipherSuites());
        builder.append(", getCipherSuitesFilter()=");
        builder.append(this.getCipherSuitesFilter());
        builder.append(", getSecureSocketProtocols()=");
        builder.append(this.getSecureSocketProtocols());
        builder.append(", getSecureSocketProtocolsFilter()=");
        builder.append(this.getSecureSocketProtocolsFilter());
        builder.append(", getSessionTimeout()=");
        builder.append(this.getSessionTimeout());
        builder.append("]");
        return builder.toString();
    }
}

