/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.camel.Exchange;
import org.apache.camel.converter.stream.OutputStreamBuilder;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;

public class ZipDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private int compressionLevel;

    public ZipDataFormat() {
        this.compressionLevel = 1;
    }

    public ZipDataFormat(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    public String getDataFormatName() {
        return "zip";
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        Deflater deflater = new Deflater(this.compressionLevel);
        DeflaterOutputStream zipOutput = new DeflaterOutputStream(stream, deflater);
        try {
            IOHelper.copy(is, zipOutput);
        }
        catch (Throwable throwable) {
            IOHelper.close(is, zipOutput);
            deflater.end();
            throw throwable;
        }
        IOHelper.close(is, zipOutput);
        deflater.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Object object;
        InflaterInputStream inflaterInputStream = new InflaterInputStream(inputStream);
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange(exchange);
        try {
            IOHelper.copy(inflaterInputStream, osb);
            object = osb.build();
        }
        catch (Throwable throwable) {
            IOHelper.close(osb, inflaterInputStream, inputStream);
            throw throwable;
        }
        IOHelper.close(osb, inflaterInputStream, inputStream);
        return object;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

