/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerFileExclusiveReadLockStrategy
implements GenericFileExclusiveReadLockStrategy<File> {
    private static final Logger LOG = LoggerFactory.getLogger(MarkerFileExclusiveReadLockStrategy.class);
    private boolean markerFile = true;
    private boolean deleteOrphanLockFiles = true;

    @Override
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) {
        if (this.deleteOrphanLockFiles) {
            String dir = endpoint.getConfiguration().getDirectory();
            File file = new File(dir);
            LOG.debug("Prepare on startup by deleting orphaned lock files from: {}", (Object)dir);
            Pattern excludePattern = endpoint.getExclude() != null ? Pattern.compile(endpoint.getExclude()) : null;
            Pattern includePattern = endpoint.getInclude() != null ? Pattern.compile(endpoint.getInclude()) : null;
            String endpointPath = endpoint.getConfiguration().getDirectory();
            StopWatch watch = new StopWatch();
            MarkerFileExclusiveReadLockStrategy.deleteLockFiles(file, endpoint.isRecursive(), endpointPath, endpoint.getFilter(), endpoint.getAntFilter(), excludePattern, includePattern);
            if (watch.taken() > 1000L) {
                LOG.info("Prepared on startup by deleting orphaned lock files from: {} took {} millis to complete.", (Object)dir, (Object)watch.taken());
            }
        }
    }

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        if (!this.markerFile) {
            return true;
        }
        String lockFileName = MarkerFileExclusiveReadLockStrategy.getLockFileName(file);
        LOG.trace("Locking the file: {} using the lock file name: {}", file, (Object)lockFileName);
        boolean acquired = FileUtil.createNewFile(new File(lockFileName));
        exchange.setProperty(MarkerFileExclusiveReadLockStrategy.asReadLockKey(file, "CamelFileLockFileAcquired"), acquired);
        exchange.setProperty(MarkerFileExclusiveReadLockStrategy.asReadLockKey(file, "CamelFileLockFileName"), lockFileName);
        return acquired;
    }

    @Override
    public void releaseExclusiveReadLockOnAbort(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        this.doReleaseExclusiveReadLock(operations, file, exchange);
    }

    @Override
    public void releaseExclusiveReadLockOnRollback(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        this.doReleaseExclusiveReadLock(operations, file, exchange);
    }

    @Override
    public void releaseExclusiveReadLockOnCommit(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        this.doReleaseExclusiveReadLock(operations, file, exchange);
    }

    protected void doReleaseExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        String lockFileName;
        File lock;
        if (!this.markerFile) {
            return;
        }
        boolean acquired = exchange.getProperty(MarkerFileExclusiveReadLockStrategy.asReadLockKey(file, "CamelFileLockFileAcquired"), false, Boolean.class);
        if (acquired && (lock = new File(lockFileName = exchange.getProperty(MarkerFileExclusiveReadLockStrategy.asReadLockKey(file, "CamelFileLockFileName"), String.class))).exists()) {
            LOG.trace("Unlocking file: {}", (Object)lockFileName);
            boolean deleted = FileUtil.deleteFile(lock);
            LOG.trace("Lock file: {} was deleted: {}", (Object)lockFileName, (Object)deleted);
        }
    }

    @Override
    public void setTimeout(long timeout) {
    }

    @Override
    public void setCheckInterval(long checkInterval) {
    }

    @Override
    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
    }

    @Override
    public void setMarkerFiler(boolean markerFile) {
        this.markerFile = markerFile;
    }

    @Override
    public void setDeleteOrphanLockFiles(boolean deleteOrphanLockFiles) {
        this.deleteOrphanLockFiles = deleteOrphanLockFiles;
    }

    private static void deleteLockFiles(File dir, boolean recursive, String endpointPath, GenericFileFilter filter, GenericFileFilter antFilter, Pattern excludePattern, Pattern includePattern) {
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.getName().startsWith(".") || (filter != null || antFilter != null || excludePattern != null || includePattern != null) && !MarkerFileExclusiveReadLockStrategy.acceptFile(file, endpointPath, filter, antFilter, excludePattern, includePattern)) continue;
            if (file.getName().endsWith(".camelLock")) {
                LOG.warn("Deleting orphaned lock file: " + file);
                FileUtil.deleteFile(file);
                continue;
            }
            if (!recursive || !file.isDirectory()) continue;
            MarkerFileExclusiveReadLockStrategy.deleteLockFiles(file, true, endpointPath, filter, antFilter, excludePattern, includePattern);
        }
    }

    private static boolean acceptFile(File file, String endpointPath, GenericFileFilter filter, GenericFileFilter antFilter, Pattern excludePattern, Pattern includePattern) {
        GenericFile<File> gf = new GenericFile<File>();
        gf.setEndpointPath(endpointPath);
        gf.setFile(file);
        gf.setFileNameOnly(file.getName());
        gf.setFileLength(file.length());
        gf.setDirectory(file.isDirectory());
        gf.setAbsolute(FileUtil.isAbsolute(file));
        gf.setAbsoluteFilePath(file.getAbsolutePath());
        gf.setLastModified(file.lastModified());
        String endpointNormalized = FileUtil.normalizePath(endpointPath);
        File path = file.getPath().startsWith(endpointNormalized + File.separator) ? new File(ObjectHelper.after(file.getPath(), endpointNormalized + File.separator)) : new File(file.getPath());
        if (path.getParent() != null) {
            gf.setRelativeFilePath(path.getParent() + File.separator + file.getName());
        } else {
            gf.setRelativeFilePath(path.getName());
        }
        gf.setFileName(gf.getRelativeFilePath());
        if (filter != null && !filter.accept(gf)) {
            return false;
        }
        if (antFilter != null && !antFilter.accept(gf)) {
            return false;
        }
        if (excludePattern != null && excludePattern.matcher(file.getName()).matches()) {
            return false;
        }
        return includePattern == null || includePattern.matcher(file.getName()).matches();
    }

    private static String getLockFileName(GenericFile<File> file) {
        return file.getAbsoluteFilePath() + ".camelLock";
    }

    private static String asReadLockKey(GenericFile file, String key) {
        String path = file.getCopyFromAbsoluteFilePath() != null ? file.getCopyFromAbsoluteFilePath() : file.getAbsoluteFilePath();
        return path + "-" + key;
    }
}

