/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.exps.AbstractVal;
import org.apache.openjpa.jdbc.kernel.exps.BinaryOpExpState;
import org.apache.openjpa.jdbc.kernel.exps.Exp;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.kernel.exps.WhenScalar;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Raw;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.meta.ClassMetaData;

public class SimpleCaseExpression
extends AbstractVal {
    private final Val _caseOperand;
    private final Exp[] _exp;
    private final Val _val;
    private ClassMetaData _meta = null;
    private Class _cast = null;
    private Value other = null;
    private ExpState otherState = null;

    public SimpleCaseExpression(Val caseOperand, Exp[] exp, Val val) {
        this._caseOperand = caseOperand;
        this._exp = exp;
        this._val = val;
    }

    public Val getCaseOperand() {
        return this._caseOperand;
    }

    public Exp[] getExp() {
        return this._exp;
    }

    public Val getVal() {
        return this._val;
    }

    public Class getType() {
        if (this._cast != null) {
            return this._cast;
        }
        Class type = this._val.getType();
        for (int i = 0; i < this._exp.length; ++i) {
            type = Filters.promote((Class)type, (Class)((WhenScalar)this._exp[i]).getVal2().getType());
        }
        if (type == Raw.class) {
            return String.class;
        }
        return type;
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        ExpState[] states = new ExpState[this._exp.length + 2];
        Joins joins = null;
        states[0] = this._caseOperand.initialize(sel, ctx, 0);
        joins = joins == null ? states[0].joins : sel.and(joins, states[0].joins);
        for (int i = 0; i < this._exp.length; ++i) {
            states[i + 1] = this._exp[i].initialize(sel, ctx, null);
            joins = joins == null ? states[i + 1].joins : sel.and(joins, states[i + 1].joins);
        }
        states[this._exp.length + 1] = this._val.initialize(sel, ctx, 0);
        joins = joins == null ? states[this._exp.length + 1].joins : sel.and(joins, states[this._exp.length + 1].joins);
        return new SimpleCaseExpState(joins, states);
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer buf, int index) {
        SimpleCaseExpState cstate = (SimpleCaseExpState)state;
        DBDictionary dict = ctx.store.getDBDictionary();
        buf.append(" CASE ");
        for (int i = 0; i < this._exp.length; ++i) {
            if (!dict.supportsSimpleCaseExpression) {
                buf.append(" WHEN ");
            }
            if (i == 0 || !dict.supportsSimpleCaseExpression) {
                this._caseOperand.appendTo(sel, ctx, cstate.states[0], buf, 0);
            }
            if (!dict.supportsSimpleCaseExpression) {
                buf.append(" = ");
            } else {
                buf.append(" WHEN ");
            }
            this._exp[i].appendTo(sel, ctx, cstate.states[i + 1], buf);
        }
        buf.append(" ELSE ");
        this._val.appendTo(sel, ctx, cstate.states[this._exp.length + 1], buf, 0);
        buf.append(" END ");
    }

    @Override
    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        SimpleCaseExpState cstate = (SimpleCaseExpState)state;
        this._caseOperand.selectColumns(sel, ctx, cstate.states[0], pks);
        for (int i = 0; i < this._exp.length; ++i) {
            this._exp[i].selectColumns(sel, ctx, cstate.states[i + 1], pks);
        }
        this._val.selectColumns(sel, ctx, cstate.states[this._exp.length + 1], pks);
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter((Value)this);
        this._caseOperand.acceptVisit(visitor);
        for (int i = 0; i < this._exp.length; ++i) {
            this._exp[i].acceptVisit(visitor);
        }
        this._val.acceptVisit(visitor);
        visitor.exit((Value)this);
    }

    @Override
    public int getId() {
        return 13;
    }

    @Override
    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        SimpleCaseExpState cstate = (SimpleCaseExpState)state;
        this._caseOperand.calculateValue(sel, ctx, cstate.states[0], other, otherState);
        for (int i = 0; i < this._exp.length; ++i) {
            BinaryOpExpState bstate = (BinaryOpExpState)cstate.states[i + 1];
            ((WhenScalar)this._exp[i]).getVal1().calculateValue(sel, ctx, bstate.state1, null, null);
            ((WhenScalar)this._exp[i]).getVal2().calculateValue(sel, ctx, bstate.state2, other, otherState);
        }
        this._val.calculateValue(sel, ctx, cstate.states[this._exp.length + 1], other, otherState);
    }

    @Override
    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
        sel.groupBy(this.newSQLBuffer(sel, ctx, state));
    }

    @Override
    public int length(Select sel, ExpContext ctx, ExpState state) {
        return 1;
    }

    private SQLBuffer newSQLBuffer(Select sel, ExpContext ctx, ExpState state) {
        this.calculateValue(sel, ctx, state, (Val)this.other, this.otherState);
        SQLBuffer buf = new SQLBuffer(ctx.store.getDBDictionary());
        this.appendTo(sel, ctx, state, buf, 0);
        return buf;
    }

    @Override
    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        return Filters.convert((Object)res.getObject(this, 1012, null), (Class)this.getType());
    }

    @Override
    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
        sel.orderBy(this.newSQLBuffer(sel, ctx, state), asc, false, this.getSelectAs());
    }

    @Override
    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        sel.select(this.newSQLBuffer(sel, ctx, state), (Object)this);
    }

    public ClassMetaData getMetaData() {
        return this._meta;
    }

    public void setImplicitType(Class type) {
        this._cast = type;
    }

    public void setMetaData(ClassMetaData meta) {
        this._meta = meta;
    }

    public void setOtherPath(Value other) {
        this.other = other;
    }

    public Value getOtherPath() {
        return this.other;
    }

    public void setOtherState(ExpState otherState) {
        this.otherState = otherState;
    }

    public ExpState getOtherState() {
        return this.otherState;
    }

    private static class SimpleCaseExpState
    extends ExpState {
        public ExpState[] states;

        public SimpleCaseExpState(Joins joins, ExpState[] states) {
            super(joins);
            this.states = states;
        }
    }
}

