/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.annotations.ExtPage;
import org.apache.syncope.client.console.pages.BaseExtPage;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.rest.SCIMConfRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.JsonEditorPanel;
import org.apache.syncope.common.lib.scim.SCIMComplexConf;
import org.apache.syncope.common.lib.scim.SCIMEnterpriseUserConf;
import org.apache.syncope.common.lib.scim.SCIMUserConf;
import org.apache.syncope.common.lib.scim.SCIMUserNameConf;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

@ExtPage(label="SCIM 2.0", icon="fa-cloud", listEntitlement="SCIM_CONF_GET", priority=100)
public class SCIMConf
extends BaseExtPage {
    private static final long serialVersionUID = 9128779230455599119L;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final SCIMConfRestClient restClient = new SCIMConfRestClient();

    public SCIMConf(PageParameters parameters) {
        super(parameters);
        this.body.add(new Component[]{BookmarkablePageLinkBuilder.build((String)"dashboard", (String)"dashboardBr", Dashboard.class)});
        final BaseModal modal = new BaseModal("modal");
        modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                modal.show(false);
            }
        });
        modal.size(Modal.Size.Large);
        modal.addSubmitButton();
        this.body.add(new Component[]{modal});
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        this.body.add(new Component[]{content});
        String confString = "";
        try {
            org.apache.syncope.common.lib.scim.SCIMConf conf = this.restClient.get();
            if (conf.getUserConf() == null) {
                conf.setUserConf(new SCIMUserConf());
            }
            if (conf.getUserConf().getName() == null) {
                conf.getUserConf().setName(new SCIMUserNameConf());
            }
            if (conf.getUserConf().getEmails().isEmpty()) {
                conf.getUserConf().getEmails().add(new SCIMComplexConf());
            }
            if (conf.getEnterpriseUserConf() == null) {
                conf.setEnterpriseUserConf(new SCIMEnterpriseUserConf());
            }
            confString = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)conf);
        }
        catch (Exception e) {
            LOG.error("While reading SCIM configuration", (Throwable)e);
            SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
        }
        final Model confModel = Model.of((Serializable)((Object)confString));
        content.add(new Component[]{new AjaxLink<Void>("edit"){
            private static final long serialVersionUID = -4331619903296515985L;

            public void onClick(AjaxRequestTarget target) {
                modal.header((IModel)new ResourceModel("editConf"));
                modal.setContent((ModalPanel)new JsonEditorPanel(modal, (IModel)confModel, false, SCIMConf.this.getPageReference()){
                    private static final long serialVersionUID = -8927036362466990179L;

                    public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                        try {
                            SCIMConf.this.restClient.set((org.apache.syncope.common.lib.scim.SCIMConf)MAPPER.readValue((String)((Object)confModel.getObject()), org.apache.syncope.common.lib.scim.SCIMConf.class));
                            SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                            this.modal.show(false);
                            this.modal.close((IPartialPageRequestHandler)target);
                        }
                        catch (Exception e) {
                            LOG.error("While setting SCIM configuration", (Throwable)e);
                            SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
                        }
                        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                });
                modal.show(true);
                target.add(new Component[]{modal});
            }
        }});
    }
}

