/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.wicket.NonResettingRestartException;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class HomePage
extends WebPage {
    private static final long serialVersionUID = -3422492668689122688L;

    public HomePage(PageParameters parameters) {
        super(parameters);
        StringBuilder redirectUrl = new StringBuilder("/app/");
        if (!parameters.get("errorMessage").isNull()) {
            redirectUrl.append("#!self?errorMessage=");
            this.appendMessage(redirectUrl, parameters.get("errorMessage").toString());
        } else if (!parameters.get("successMessage").isNull()) {
            redirectUrl.append("#!self?successMessage=");
            this.appendMessage(redirectUrl, parameters.get("successMessage").toString());
        }
        throw new NonResettingRestartException(redirectUrl.toString());
    }

    private void appendMessage(StringBuilder redirectUrl, String message) {
        try {
            redirectUrl.append(URLEncoder.encode(message, StandardCharsets.UTF_8.name()));
        }
        catch (Exception e) {
            redirectUrl.append("Generic error");
        }
    }
}

